/*
 * Copyright 2023 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _pcie_6_1_0_OFFSET_HEADER
#define _pcie_6_1_0_OFFSET_HEADER


// addressBlock: pcie_container_pcs0_pcie_lcu_pcie_pcs_prime_pcie_master_x1_xx16_pcs_prime_dir
// base address: 0x11a08000
#define regDXIO_HWDID                                                                                   0x2270800
#define regDXIO_HWDID_BASE_IDX                                                                          0
#define regDXIO_LINKAGE_LANEGRP                                                                         0x2270802
#define regDXIO_LINKAGE_LANEGRP_BASE_IDX                                                                0
#define regDXIO_LINKAGE_KPDMX                                                                           0x2270803
#define regDXIO_LINKAGE_KPDMX_BASE_IDX                                                                  0
#define regDXIO_LINKAGE_KPMX                                                                            0x2270804
#define regDXIO_LINKAGE_KPFIFO                                                                          0x2270805
#define regDXIO_LINKAGE_KPNP                                                                            0x2270806
#define regMAC_CAPABILITIES1                                                                            0x2270814
#define regMAC_CAPABILITIES1_BASE_IDX                                                                   0
#define regMAC_CAPABILITIES2                                                                            0x2270815
#define regMAC_CAPABILITIES2_BASE_IDX                                                                   0


// addressBlock: pcie_container_pcie0_pswuscfg0_cfgdecp
// base address: 0x1a300000
#define regCOMMAND                                                                                      0x0001
#define regCOMMAND_BASE_IDX                                                                             1
#define regSTATUS                                                                                       0x0001
#define regSTATUS_BASE_IDX                                                                              1
#define regLATENCY                                                                                      0x0003
#define regLATENCY_BASE_IDX                                                                             1
#define regHEADER                                                                                       0x0003
#define regHEADER_BASE_IDX                                                                              1
#define regPCIE_LANE_ERROR_STATUS                                                                       0x009e
#define regPCIE_LANE_ERROR_STATUS_BASE_IDX                                                              1
#define regPCIE_LANE_0_EQUALIZATION_CNTL                                                                0x009f
#define regPCIE_LANE_0_EQUALIZATION_CNTL_BASE_IDX                                                       1
#define regPCIE_LANE_1_EQUALIZATION_CNTL                                                                0x009f
#define regPCIE_LANE_1_EQUALIZATION_CNTL_BASE_IDX                                                       1
#define regPCIE_LANE_2_EQUALIZATION_CNTL                                                                0x00a0
#define regPCIE_LANE_2_EQUALIZATION_CNTL_BASE_IDX                                                       1
#define regPCIE_LANE_3_EQUALIZATION_CNTL                                                                0x00a0
#define regPCIE_LANE_3_EQUALIZATION_CNTL_BASE_IDX                                                       1
#define regPCIE_LANE_4_EQUALIZATION_CNTL                                                                0x00a1
#define regPCIE_LANE_4_EQUALIZATION_CNTL_BASE_IDX                                                       1
#define regPCIE_LANE_5_EQUALIZATION_CNTL                                                                0x00a1
#define regPCIE_LANE_5_EQUALIZATION_CNTL_BASE_IDX                                                       1
#define regPCIE_LANE_6_EQUALIZATION_CNTL                                                                0x00a2
#define regPCIE_LANE_6_EQUALIZATION_CNTL_BASE_IDX                                                       1
#define regPCIE_LANE_7_EQUALIZATION_CNTL                                                                0x00a2
#define regPCIE_LANE_7_EQUALIZATION_CNTL_BASE_IDX                                                       1
#define regPCIE_LANE_8_EQUALIZATION_CNTL                                                                0x00a3
#define regPCIE_LANE_8_EQUALIZATION_CNTL_BASE_IDX                                                       1
#define regPCIE_LANE_9_EQUALIZATION_CNTL                                                                0x00a3
#define regPCIE_LANE_9_EQUALIZATION_CNTL_BASE_IDX                                                       1
#define regPCIE_LANE_10_EQUALIZATION_CNTL                                                               0x00a4
#define regPCIE_LANE_10_EQUALIZATION_CNTL_BASE_IDX                                                      1
#define regPCIE_LANE_11_EQUALIZATION_CNTL                                                               0x00a4
#define regPCIE_LANE_11_EQUALIZATION_CNTL_BASE_IDX                                                      1
#define regPCIE_LANE_12_EQUALIZATION_CNTL                                                               0x00a5
#define regPCIE_LANE_12_EQUALIZATION_CNTL_BASE_IDX                                                      1
#define regPCIE_LANE_13_EQUALIZATION_CNTL                                                               0x00a5
#define regPCIE_LANE_13_EQUALIZATION_CNTL_BASE_IDX                                                      1
#define regPCIE_LANE_14_EQUALIZATION_CNTL                                                               0x00a6
#define regPCIE_LANE_14_EQUALIZATION_CNTL_BASE_IDX                                                      1
#define regPCIE_LANE_15_EQUALIZATION_CNTL                                                               0x00a6
#define regPCIE_LANE_15_EQUALIZATION_CNTL_BASE_IDX                                                      1
#define regPCIE_LTR_ENH_CAP_LIST                                                                        0x00c8
#define regPCIE_LTR_ENH_CAP_LIST_BASE_IDX                                                               1
#define regPCIE_LTR_CAP                                                                                 0x00c9
#define regPCIE_LTR_CAP_BASE_IDX                                                                        1
#define regPCIE_L1_PM_SUB_CAP_LIST                                                                      0x00dc
#define regPCIE_L1_PM_SUB_CAP_LIST_BASE_IDX                                                             1
#define regPCIE_L1_PM_SUB_CAP                                                                           0x00dd
#define regPCIE_L1_PM_SUB_CAP_BASE_IDX                                                                  1
#define regPCIE_L1_PM_SUB_CNTL                                                                          0x00de
#define regPCIE_L1_PM_SUB_CNTL_BASE_IDX                                                                 1
#define regPCIE_L1_PM_SUB_CNTL2                                                                         0x00df
#define regPCIE_L1_PM_SUB_CNTL2_BASE_IDX                                                                1
#define regPCIE_MARGINING_ENH_CAP_LIST                                                                  0x0110
#define regPCIE_MARGINING_ENH_CAP_LIST_BASE_IDX                                                         1


// addressBlock: pcie_container_pcie0_pswusp0_pciedir_p
// base address: 0x1a340000
#define regPCIEP_RESERVED                                                                               0x10000
#define regPCIEP_RESERVED_BASE_IDX                                                                      1
#define regPCIEP_SCRATCH                                                                                0x10001
#define regPCIEP_SCRATCH_BASE_IDX                                                                       1
#define regPCIEP_PORT_CNTL                                                                              0x10010
#define regPCIEP_PORT_CNTL_BASE_IDX                                                                     1
#define regPCIE_TX_REQUESTER_ID                                                                         0x10021
#define regPCIE_TX_REQUESTER_ID_BASE_IDX                                                                1
#define regPCIE_P_PORT_LANE_STATUS                                                                      0x10050
#define regPCIE_P_PORT_LANE_STATUS_BASE_IDX                                                             1
#define regPCIE_ERR_CNTL                                                                                0x1006a
#define regPCIE_ERR_CNTL_BASE_IDX                                                                       1
#define regPCIE_RX_CNTL                                                                                 0x10070
#define regPCIE_RX_CNTL_BASE_IDX                                                                        1
#define regPCIE_RX_EXPECTED_SEQNUM                                                                      0x10071
#define regPCIE_RX_EXPECTED_SEQNUM_BASE_IDX                                                             1
#define regPCIE_RX_VENDOR_SPECIFIC                                                                      0x10072
#define regPCIE_RX_VENDOR_SPECIFIC_BASE_IDX                                                             1
#define regPCIE_RX_CNTL3                                                                                0x10074
#define regPCIE_RX_CNTL3_BASE_IDX                                                                       1
#define regPCIE_RX_CREDITS_ALLOCATED_P                                                                  0x10080
#define regPCIE_RX_CREDITS_ALLOCATED_P_BASE_IDX                                                         1
#define regPCIE_RX_CREDITS_ALLOCATED_NP                                                                 0x10081
#define regPCIE_RX_CREDITS_ALLOCATED_NP_BASE_IDX                                                        1
#define regPCIE_RX_CREDITS_ALLOCATED_CPL                                                                0x10082
#define regPCIE_RX_CREDITS_ALLOCATED_CPL_BASE_IDX                                                       1
#define regPCIEP_ERROR_INJECT_PHYSICAL                                                                  0x10083
#define regPCIEP_ERROR_INJECT_PHYSICAL_BASE_IDX                                                         1
#define regPCIEP_ERROR_INJECT_TRANSACTION                                                               0x10084
#define regPCIEP_ERROR_INJECT_TRANSACTION_BASE_IDX                                                      1
#define regPCIEP_NAK_COUNTER                                                                            0x10086
#define regPCIEP_NAK_COUNTER_BASE_IDX                                                                   1
#define regPCIE_LC_CNTL                                                                                 0x100a0
#define regPCIE_LC_CNTL_BASE_IDX                                                                        1
#define regPCIE_LC_TRAINING_CNTL                                                                        0x100a1
#define regPCIE_LC_TRAINING_CNTL_BASE_IDX                                                               1
#define regPCIE_LC_LINK_WIDTH_CNTL                                                                      0x100a2
#define regPCIE_LC_LINK_WIDTH_CNTL_BASE_IDX                                                             1
#define regPCIE_LC_N_FTS_CNTL                                                                           0x100a3
#define regPCIE_LC_N_FTS_CNTL_BASE_IDX                                                                  1
#define regPCIE_LC_SPEED_CNTL                                                                           0x100a4
#define regPCIE_LC_SPEED_CNTL_BASE_IDX                                                                  1
#define regPCIE_LC_STATE0                                                                               0x100a5
#define regPCIE_LC_STATE0_BASE_IDX                                                                      1
#define regPCIE_LC_STATE1                                                                               0x100a6
#define regPCIE_LC_STATE1_BASE_IDX                                                                      1
#define regPCIE_LC_STATE2                                                                               0x100a7
#define regPCIE_LC_STATE2_BASE_IDX                                                                      1
#define regPCIE_LC_STATE3                                                                               0x100a8
#define regPCIE_LC_STATE3_BASE_IDX                                                                      1
#define regPCIE_LC_STATE4                                                                               0x100a9
#define regPCIE_LC_STATE4_BASE_IDX                                                                      1
#define regPCIE_LC_STATE5                                                                               0x100aa
#define regPCIE_LC_STATE5_BASE_IDX                                                                      1
#define regPCIE_LC_LINK_MANAGEMENT_CNTL2                                                                0x100ab
#define regPCIE_LC_LINK_MANAGEMENT_CNTL2_BASE_IDX                                                       1
#define regPCIE_LC_CNTL2                                                                                0x100b1
#define regPCIE_LC_CNTL2_BASE_IDX                                                                       1
#define regPCIE_LC_BW_CHANGE_CNTL                                                                       0x100b2
#define regPCIE_LC_BW_CHANGE_CNTL_BASE_IDX                                                              1
#define regPCIE_LC_CDR_CNTL                                                                             0x100b3
#define regPCIE_LC_CDR_CNTL_BASE_IDX                                                                    1
#define regPCIE_LC_LANE_CNTL                                                                            0x100b4
#define regPCIE_LC_LANE_CNTL_BASE_IDX                                                                   1
#define regPCIE_LC_CNTL3                                                                                0x100b5
#define regPCIE_LC_CNTL3_BASE_IDX                                                                       1
#define regPCIE_LC_CNTL4                                                                                0x100b6
#define regPCIE_LC_CNTL4_BASE_IDX                                                                       1
#define regPCIE_LC_CNTL5                                                                                0x100b7
#define regPCIE_LC_CNTL5_BASE_IDX                                                                       1
#define regPCIE_LC_FORCE_COEFF                                                                          0x100b8
#define regPCIE_LC_FORCE_COEFF_BASE_IDX                                                                 1
#define regPCIE_LC_BEST_EQ_SETTINGS                                                                     0x100b9
#define regPCIE_LC_BEST_EQ_SETTINGS_BASE_IDX                                                            1
#define regPCIE_LC_FORCE_EQ_REQ_COEFF                                                                   0x100ba
#define regPCIE_LC_FORCE_EQ_REQ_COEFF_BASE_IDX                                                          1
#define regPCIE_LC_CNTL6                                                                                0x100bb
#define regPCIE_LC_CNTL6_BASE_IDX                                                                       1
#define regPCIE_LC_CNTL7                                                                                0x100bc
#define regPCIE_LC_CNTL7_BASE_IDX                                                                       1
#define regPCIE_LC_LINK_MANAGEMENT_STATUS                                                               0x100bd
#define regPCIE_LC_LINK_MANAGEMENT_STATUS_BASE_IDX                                                      1
#define regPCIE_LC_LINK_MANAGEMENT_MASK                                                                 0x100be
#define regPCIE_LC_LINK_MANAGEMENT_MASK_BASE_IDX                                                        1
#define regPCIE_LC_LINK_MANAGEMENT_CNTL                                                                 0x100bf
#define regPCIE_LC_LINK_MANAGEMENT_CNTL_BASE_IDX                                                        1
#define regPCIEP_STRAP_LC                                                                               0x100c0
#define regPCIEP_STRAP_LC_BASE_IDX                                                                      1
#define regPCIEP_STRAP_MISC                                                                             0x100c1
#define regPCIEP_STRAP_MISC_BASE_IDX                                                                    1
#define regPCIEP_STRAP_LC2                                                                              0x100c2
#define regPCIEP_STRAP_LC2_BASE_IDX                                                                     1
#define regPCIE_LC_L1_PM_SUBSTATE                                                                       0x100c6
#define regPCIE_LC_L1_PM_SUBSTATE_BASE_IDX                                                              1
#define regPCIE_LC_L1_PM_SUBSTATE2                                                                      0x100c7
#define regPCIE_LC_L1_PM_SUBSTATE2_BASE_IDX                                                             1
#define regPCIE_LC_L1_PM_SUBSTATE3                                                                      0x100c8
#define regPCIE_LC_L1_PM_SUBSTATE3_BASE_IDX                                                             1
#define regPCIE_LC_L1_PM_SUBSTATE4                                                                      0x100c9
#define regPCIE_LC_L1_PM_SUBSTATE4_BASE_IDX                                                             1
#define regPCIE_LC_L1_PM_SUBSTATE5                                                                      0x100ca
#define regPCIE_LC_L1_PM_SUBSTATE5_BASE_IDX                                                             1
#define regPCIEP_BCH_ECC_CNTL                                                                           0x100d0
#define regPCIEP_BCH_ECC_CNTL_BASE_IDX                                                                  1
#define regPCIE_LC_CNTL8                                                                                0x100dd
#define regPCIE_LC_CNTL8_BASE_IDX                                                                       1
#define regPCIE_LC_CNTL9                                                                                0x100de
#define regPCIE_LC_CNTL9_BASE_IDX                                                                       1
#define regPCIE_LC_FORCE_COEFF2                                                                         0x100df
#define regPCIE_LC_FORCE_COEFF2_BASE_IDX                                                                1
#define regPCIE_LC_FORCE_EQ_REQ_COEFF2                                                                  0x100e0
#define regPCIE_LC_FORCE_EQ_REQ_COEFF2_BASE_IDX                                                         1
#define regPCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES                                                        0x100e2
#define regPCIE_LC_FINE_GRAIN_CLK_GATE_OVERRIDES_BASE_IDX                                               1
#define regPCIE_LC_CNTL10                                                                               0x100e3
#define regPCIE_LC_CNTL10_BASE_IDX                                                                      1
#define regPCIE_LC_EQ_CNTL_8GT                                                                          0x100e4
#define regPCIE_LC_EQ_CNTL_8GT_BASE_IDX                                                                 1
#define regPCIE_LC_EQ_CNTL_16GT                                                                         0x100e5
#define regPCIE_LC_EQ_CNTL_16GT_BASE_IDX                                                                1
#define regPCIE_LC_SAVE_RESTORE_1                                                                       0x100e6
#define regPCIE_LC_SAVE_RESTORE_1_BASE_IDX                                                              1
#define regPCIE_LC_SAVE_RESTORE_2                                                                       0x100e7
#define regPCIE_LC_SAVE_RESTORE_2_BASE_IDX                                                              1
#define regPCIE_LC_SAVE_RESTORE_3                                                                       0x100e8
#define regPCIE_LC_SAVE_RESTORE_3_BASE_IDX                                                              1
#define regPCIE_LC_EQ_CNTL_32GT                                                                         0x10100
#define regPCIE_LC_EQ_CNTL_32GT_BASE_IDX                                                                1
#define regPCIE_LC_PRESET_MASK_CNTL                                                                     0x10101
#define regPCIE_LC_PRESET_MASK_CNTL_BASE_IDX                                                            1
#define regPCIE_LC_RXRECOVER_RXSTANDBY_CNTL                                                             0x10102
#define regPCIE_LC_RXRECOVER_RXSTANDBY_CNTL_BASE_IDX                                                    1
#define regPCIE_LC_CNTL11                                                                               0x10103
#define regPCIE_LC_CNTL11_BASE_IDX                                                                      1
#define regPCIE_LC_CNTL12                                                                               0x10104
#define regPCIE_LC_CNTL12_BASE_IDX                                                                      1
#define regPCIE_LC_SPEED_CNTL2                                                                          0x10105
#define regPCIE_LC_SPEED_CNTL2_BASE_IDX                                                                 1
#define regPCIE_LC_FORCE_COEFF3                                                                         0x10106
#define regPCIE_LC_FORCE_COEFF3_BASE_IDX                                                                1
#define regPCIE_LC_FORCE_EQ_REQ_COEFF3                                                                  0x10107
#define regPCIE_LC_FORCE_EQ_REQ_COEFF3_BASE_IDX                                                         1
#define regPCIE_LC_LINK_MANAGEMENT_CNTL3                                                                0x10108
#define regPCIE_LC_LINK_MANAGEMENT_CNTL3_BASE_IDX                                                       1
#define regPCIE_LC_Z10_IDLE_CNTL                                                                        0x1010f
#define regPCIE_LC_Z10_IDLE_CNTL_BASE_IDX                                                               1
#define regPCIE_LC_TRANMIT_FIFO_CDC_CNTL                                                                0x1011a
#define regPCIE_LC_TRANMIT_FIFO_CDC_CNTL_BASE_IDX                                                       1
#define regPCIE_LC_CNTL13                                                                               0x1011c
#define regPCIE_LC_CNTL13_BASE_IDX                                                                      1
#define regPCIE_LC_SWDS_CNTL                                                                            0x1011d
#define regPCIE_LC_SWDS_CNTL_BASE_IDX                                                                   1
#define regPCIE_TX_SEQ                                                                                  0x10188
#define regPCIE_TX_SEQ_BASE_IDX                                                                         1
#define regPCIE_TX_REPLAY                                                                               0x10189
#define regPCIE_TX_REPLAY_BASE_IDX                                                                      1
#define regPCIE_TX_ACK_LATENCY_LIMIT                                                                    0x1018c
#define regPCIE_TX_ACK_LATENCY_LIMIT_BASE_IDX                                                           1
#define regPCIE_TX_CREDITS_FCU_THRESHOLD                                                                0x10190
#define regPCIE_TX_CREDITS_FCU_THRESHOLD_BASE_IDX                                                       1
#define regPCIE_TX_VENDOR_SPECIFIC                                                                      0x10194
#define regPCIE_TX_VENDOR_SPECIFIC_BASE_IDX                                                             1
#define regPCIE_TX_NOP_DLLP                                                                             0x10195
#define regPCIE_TX_NOP_DLLP_BASE_IDX                                                                    1
#define regPCIE_TX_REQUEST_NUM_CNTL                                                                     0x10198
#define regPCIE_TX_REQUEST_NUM_CNTL_BASE_IDX                                                            1
#define regPCIE_TX_CREDITS_ADVT_P                                                                       0x101a0
#define regPCIE_TX_CREDITS_ADVT_P_BASE_IDX                                                              1
#define regPCIE_TX_CREDITS_ADVT_NP                                                                      0x101a1
#define regPCIE_TX_CREDITS_ADVT_NP_BASE_IDX                                                             1
#define regPCIE_TX_CREDITS_ADVT_CPL                                                                     0x101a2
#define regPCIE_TX_CREDITS_ADVT_CPL_BASE_IDX                                                            1
#define regPCIE_TX_CREDITS_INIT_P                                                                       0x101a3
#define regPCIE_TX_CREDITS_INIT_P_BASE_IDX                                                              1
#define regPCIE_TX_CREDITS_INIT_NP                                                                      0x101a4
#define regPCIE_TX_CREDITS_INIT_NP_BASE_IDX                                                             1
#define regPCIE_TX_CREDITS_INIT_CPL                                                                     0x101a5
#define regPCIE_TX_CREDITS_INIT_CPL_BASE_IDX                                                            1
#define regPCIE_TX_CREDITS_STATUS                                                                       0x101a6
#define regPCIE_TX_CREDITS_STATUS_BASE_IDX                                                              1
#define regPCIE_FC_P                                                                                    0x101a8
#define regPCIE_FC_P_BASE_IDX                                                                           1
#define regPCIE_FC_NP                                                                                   0x101a9
#define regPCIE_FC_NP_BASE_IDX                                                                          1
#define regPCIE_FC_CPL                                                                                  0x101aa
#define regPCIE_FC_CPL_BASE_IDX                                                                         1
#define regPCIE_FC_P_VC1                                                                                0x101ab
#define regPCIE_FC_P_VC1_BASE_IDX                                                                       1
#define regPCIE_FC_NP_VC1                                                                               0x101ac
#define regPCIE_FC_NP_VC1_BASE_IDX                                                                      1
#define regPCIE_FC_CPL_VC1                                                                              0x101ad
#define regPCIE_FC_CPL_VC1_BASE_IDX                                                                     1


// addressBlock: pcie_container_pcie0_pciedir
// base address: 0x1a380000
#define regPCIE_RESERVED                                                                                0x20000
#define regPCIE_RESERVED_BASE_IDX                                                                       1
#define regPCIE_SCRATCH                                                                                 0x20001
#define regPCIE_SCRATCH_BASE_IDX                                                                        1
#define regPCIE_RX_NUM_NAK                                                                              0x2000e
#define regPCIE_RX_NUM_NAK_BASE_IDX                                                                     1
#define regPCIE_RX_NUM_NAK_GENERATED                                                                    0x2000f
#define regPCIE_RX_NUM_NAK_GENERATED_BASE_IDX                                                           1
#define regPCIE_CNTL                                                                                    0x20010
#define regPCIE_CNTL_BASE_IDX                                                                           1
#define regPCIE_CONFIG_CNTL                                                                             0x20011
#define regPCIE_CONFIG_CNTL_BASE_IDX                                                                    1
#define regPCIE_DEBUG_CNTL                                                                              0x20012
#define regPCIE_DEBUG_CNTL_BASE_IDX                                                                     1
#define regPCIE_RX_CNTL5                                                                                0x20018
#define regPCIE_RX_CNTL5_BASE_IDX                                                                       1
#define regPCIE_RX_CNTL4                                                                                0x20019
#define regPCIE_RX_CNTL4_BASE_IDX                                                                       1
#define regPCIE_COMMON_AER_MASK                                                                         0x2001a
#define regPCIE_COMMON_AER_MASK_BASE_IDX                                                                1
#define regPCIE_CNTL2                                                                                   0x2001c
#define regPCIE_CNTL2_BASE_IDX                                                                          1
#define regPCIE_RX_CNTL2                                                                                0x2001d
#define regPCIE_RX_CNTL2_BASE_IDX                                                                       1
#define regPCIE_CI_CNTL                                                                                 0x20020
#define regPCIE_CI_CNTL_BASE_IDX                                                                        1
#define regPCIE_BUS_CNTL                                                                                0x20021
#define regPCIE_BUS_CNTL_BASE_IDX                                                                       1
#define regPCIE_LC_STATE6                                                                               0x20022
#define regPCIE_LC_STATE6_BASE_IDX                                                                      1
#define regPCIE_LC_STATE7                                                                               0x20023
#define regPCIE_LC_STATE7_BASE_IDX                                                                      1
#define regPCIE_LC_STATE8                                                                               0x20024
#define regPCIE_LC_STATE8_BASE_IDX                                                                      1
#define regPCIE_LC_STATE9                                                                               0x20025
#define regPCIE_LC_STATE9_BASE_IDX                                                                      1
#define regPCIE_LC_STATE10                                                                              0x20026
#define regPCIE_LC_STATE10_BASE_IDX                                                                     1
#define regPCIE_LC_STATE11                                                                              0x20027
#define regPCIE_LC_STATE11_BASE_IDX                                                                     1
#define regPCIE_LC_STATUS1                                                                              0x20028
#define regPCIE_LC_STATUS1_BASE_IDX                                                                     1
#define regPCIE_LC_STATUS2                                                                              0x20029
#define regPCIE_LC_STATUS2_BASE_IDX                                                                     1
#define regPCIE_WPR_CNTL                                                                                0x20030
#define regPCIE_WPR_CNTL_BASE_IDX                                                                       1
#define regPCIE_RX_LAST_TLP0                                                                            0x20031
#define regPCIE_RX_LAST_TLP0_BASE_IDX                                                                   1
#define regPCIE_RX_LAST_TLP1                                                                            0x20032
#define regPCIE_RX_LAST_TLP1_BASE_IDX                                                                   1
#define regPCIE_RX_LAST_TLP2                                                                            0x20033
#define regPCIE_RX_LAST_TLP2_BASE_IDX                                                                   1
#define regPCIE_RX_LAST_TLP3                                                                            0x20034
#define regPCIE_RX_LAST_TLP3_BASE_IDX                                                                   1
#define regPCIE_I2C_REG_ADDR_EXPAND                                                                     0x2003a
#define regPCIE_I2C_REG_ADDR_EXPAND_BASE_IDX                                                            1
#define regPCIE_I2C_REG_DATA                                                                            0x2003b
#define regPCIE_I2C_REG_DATA_BASE_IDX                                                                   1
#define regPCIE_CFG_CNTL                                                                                0x2003c
#define regPCIE_CFG_CNTL_BASE_IDX                                                                       1
#define regPCIE_LC_PM_CNTL                                                                              0x2003d
#define regPCIE_LC_PM_CNTL_BASE_IDX                                                                     1
#define regPCIE_LC_PM_CNTL2                                                                             0x2003e
#define regPCIE_LC_PM_CNTL2_BASE_IDX                                                                    1
#define regPCIE_LC_STRAP_BUFF_CNTL                                                                      0x2003f
#define regPCIE_LC_STRAP_BUFF_CNTL_BASE_IDX                                                             1
#define regPCIE_P_CNTL                                                                                  0x20040
#define regPCIE_P_CNTL_BASE_IDX                                                                         1
#define regPCIE_P_BUF_STATUS                                                                            0x20041
#define regPCIE_P_BUF_STATUS_BASE_IDX                                                                   1
#define regPCIE_P_DECODER_STATUS                                                                        0x20042
#define regPCIE_P_DECODER_STATUS_BASE_IDX                                                               1
#define regPCIE_P_MISC_STATUS                                                                           0x20043
#define regPCIE_P_MISC_STATUS_BASE_IDX                                                                  1
#define regPCIE_P_RCV_L0S_FTS_DET                                                                       0x20050
#define regPCIE_P_RCV_L0S_FTS_DET_BASE_IDX                                                              1
#define regPCIE_RX_AD                                                                                   0x20062
#define regPCIE_RX_AD_BASE_IDX                                                                          1
#define regPCIE_SDP_CTRL                                                                                0x20063
#define regPCIE_SDP_CTRL_BASE_IDX                                                                       1
#define regPCIE_SDP_SWUS_SLV_ATTR_CTRL                                                                  0x20065
#define regPCIE_SDP_SWUS_SLV_ATTR_CTRL_BASE_IDX                                                         1
#define regPCIE_SDP_CTRL2                                                                               0x20068
#define regPCIE_SDP_CTRL2_BASE_IDX                                                                      1
#define regPCIE_PERF_COUNT_CNTL                                                                         0x20080
#define regPCIE_PERF_COUNT_CNTL_BASE_IDX                                                                1
#define regPCIE_PERF_CNTL_TXCLK1                                                                        0x20081
#define regPCIE_PERF_CNTL_TXCLK1_BASE_IDX                                                               1
#define regPCIE_PERF_COUNT0_TXCLK1                                                                      0x20082
#define regPCIE_PERF_COUNT0_TXCLK1_BASE_IDX                                                             1
#define regPCIE_PERF_COUNT1_TXCLK1                                                                      0x20083
#define regPCIE_PERF_COUNT1_TXCLK1_BASE_IDX                                                             1
#define regPCIE_PERF_CNTL_TXCLK2                                                                        0x20084
#define regPCIE_PERF_CNTL_TXCLK2_BASE_IDX                                                               1
#define regPCIE_PERF_COUNT0_TXCLK2                                                                      0x20085
#define regPCIE_PERF_COUNT0_TXCLK2_BASE_IDX                                                             1
#define regPCIE_PERF_COUNT1_TXCLK2                                                                      0x20086
#define regPCIE_PERF_COUNT1_TXCLK2_BASE_IDX                                                             1
#define regPCIE_PERF_CNTL_TXCLK3                                                                        0x20087
#define regPCIE_PERF_CNTL_TXCLK3_BASE_IDX                                                               1
#define regPCIE_PERF_COUNT0_TXCLK3                                                                      0x20088
#define regPCIE_PERF_COUNT0_TXCLK3_BASE_IDX                                                             1
#define regPCIE_PERF_COUNT1_TXCLK3                                                                      0x20089
#define regPCIE_PERF_COUNT1_TXCLK3_BASE_IDX                                                             1
#define regPCIE_PERF_CNTL_TXCLK4                                                                        0x2008a
#define regPCIE_PERF_CNTL_TXCLK4_BASE_IDX                                                               1
#define regPCIE_PERF_COUNT0_TXCLK4                                                                      0x2008b
#define regPCIE_PERF_COUNT0_TXCLK4_BASE_IDX                                                             1
#define regPCIE_PERF_COUNT1_TXCLK4                                                                      0x2008c
#define regPCIE_PERF_COUNT1_TXCLK4_BASE_IDX                                                             1
#define regPCIE_PERF_CNTL_EVENT_LC_PORT_SEL                                                             0x20093
#define regPCIE_PERF_CNTL_EVENT_LC_PORT_SEL_BASE_IDX                                                    1
#define regPCIE_PERF_CNTL_EVENT_CI_PORT_SEL                                                             0x20094
#define regPCIE_PERF_CNTL_EVENT_CI_PORT_SEL_BASE_IDX                                                    1
#define regPCIE_PERF_CNTL_TXCLK5                                                                        0x20096
#define regPCIE_PERF_CNTL_TXCLK5_BASE_IDX                                                               1
#define regPCIE_PERF_COUNT0_TXCLK5                                                                      0x20097
#define regPCIE_PERF_COUNT0_TXCLK5_BASE_IDX                                                             1
#define regPCIE_PERF_COUNT1_TXCLK5                                                                      0x20098
#define regPCIE_PERF_COUNT1_TXCLK5_BASE_IDX                                                             1
#define regPCIE_PERF_CNTL_TXCLK6                                                                        0x20099
#define regPCIE_PERF_CNTL_TXCLK6_BASE_IDX                                                               1
#define regPCIE_PERF_COUNT0_TXCLK6                                                                      0x2009a
#define regPCIE_PERF_COUNT0_TXCLK6_BASE_IDX                                                             1
#define regPCIE_PERF_COUNT1_TXCLK6                                                                      0x2009b
#define regPCIE_PERF_COUNT1_TXCLK6_BASE_IDX                                                             1
#define regPCIE_STRAP_F0                                                                                0x200b0
#define regPCIE_STRAP_F0_BASE_IDX                                                                       1
#define regPCIE_STRAP_MISC                                                                              0x200c0
#define regPCIE_STRAP_MISC_BASE_IDX                                                                     1
#define regPCIE_STRAP_MISC2                                                                             0x200c1
#define regPCIE_STRAP_MISC2_BASE_IDX                                                                    1
#define regPCIE_STRAP_PI                                                                                0x200c2
#define regPCIE_STRAP_PI_BASE_IDX                                                                       1
#define regPCIE_STRAP_I2C_BD                                                                            0x200c4
#define regPCIE_STRAP_I2C_BD_BASE_IDX                                                                   1
#define regPCIE_PRBS_CLR                                                                                0x200c8
#define regPCIE_PRBS_CLR_BASE_IDX                                                                       1
#define regPCIE_PRBS_STATUS1                                                                            0x200c9
#define regPCIE_PRBS_STATUS1_BASE_IDX                                                                   1
#define regPCIE_PRBS_STATUS2                                                                            0x200ca
#define regPCIE_PRBS_STATUS2_BASE_IDX                                                                   1
#define regPCIE_PRBS_FREERUN                                                                            0x200cb
#define regPCIE_PRBS_FREERUN_BASE_IDX                                                                   1
#define regPCIE_PRBS_MISC                                                                               0x200cc
#define regPCIE_PRBS_MISC_BASE_IDX                                                                      1
#define regPCIE_PRBS_USER_PATTERN                                                                       0x200cd
#define regPCIE_PRBS_USER_PATTERN_BASE_IDX                                                              1
#define regPCIE_PRBS_LO_BITCNT                                                                          0x200ce
#define regPCIE_PRBS_LO_BITCNT_BASE_IDX                                                                 1
#define regPCIE_PRBS_HI_BITCNT                                                                          0x200cf
#define regPCIE_PRBS_HI_BITCNT_BASE_IDX                                                                 1
#define regPCIE_PRBS_ERRCNT_0                                                                           0x200d0
#define regPCIE_PRBS_ERRCNT_0_BASE_IDX                                                                  1
#define regPCIE_PRBS_ERRCNT_1                                                                           0x200d1
#define regPCIE_PRBS_ERRCNT_1_BASE_IDX                                                                  1
#define regPCIE_PRBS_ERRCNT_2                                                                           0x200d2
#define regPCIE_PRBS_ERRCNT_2_BASE_IDX                                                                  1
#define regPCIE_PRBS_ERRCNT_3                                                                           0x200d3
#define regPCIE_PRBS_ERRCNT_3_BASE_IDX                                                                  1
#define regPCIE_PRBS_ERRCNT_4                                                                           0x200d4
#define regPCIE_PRBS_ERRCNT_4_BASE_IDX                                                                  1
#define regPCIE_PRBS_ERRCNT_5                                                                           0x200d5
#define regPCIE_PRBS_ERRCNT_5_BASE_IDX                                                                  1
#define regPCIE_PRBS_ERRCNT_6                                                                           0x200d6
#define regPCIE_PRBS_ERRCNT_6_BASE_IDX                                                                  1
#define regPCIE_PRBS_ERRCNT_7                                                                           0x200d7
#define regPCIE_PRBS_ERRCNT_7_BASE_IDX                                                                  1
#define regPCIE_PRBS_ERRCNT_8                                                                           0x200d8
#define regPCIE_PRBS_ERRCNT_8_BASE_IDX                                                                  1
#define regPCIE_PRBS_ERRCNT_9                                                                           0x200d9
#define regPCIE_PRBS_ERRCNT_9_BASE_IDX                                                                  1
#define regPCIE_PRBS_ERRCNT_10                                                                          0x200da
#define regPCIE_PRBS_ERRCNT_10_BASE_IDX                                                                 1
#define regPCIE_PRBS_ERRCNT_11                                                                          0x200db
#define regPCIE_PRBS_ERRCNT_11_BASE_IDX                                                                 1
#define regPCIE_PRBS_ERRCNT_12                                                                          0x200dc
#define regPCIE_PRBS_ERRCNT_12_BASE_IDX                                                                 1
#define regPCIE_PRBS_ERRCNT_13                                                                          0x200dd
#define regPCIE_PRBS_ERRCNT_13_BASE_IDX                                                                 1
#define regPCIE_PRBS_ERRCNT_14                                                                          0x200de
#define regPCIE_PRBS_ERRCNT_14_BASE_IDX                                                                 1
#define regPCIE_PRBS_ERRCNT_15                                                                          0x200df
#define regPCIE_PRBS_ERRCNT_15_BASE_IDX                                                                 1
#define regSWRST_COMMAND_STATUS                                                                         0x20100
#define regSWRST_COMMAND_STATUS_BASE_IDX                                                                1
#define regSWRST_GENERAL_CONTROL                                                                        0x20101
#define regSWRST_GENERAL_CONTROL_BASE_IDX                                                               1
#define regSWRST_COMMAND_0                                                                              0x20102
#define regSWRST_COMMAND_0_BASE_IDX                                                                     1
#define regSWRST_COMMAND_1                                                                              0x20103
#define regSWRST_COMMAND_1_BASE_IDX                                                                     1
#define regSWRST_CONTROL_0                                                                              0x20104
#define regSWRST_CONTROL_0_BASE_IDX                                                                     1
#define regSWRST_CONTROL_1                                                                              0x20105
#define regSWRST_CONTROL_1_BASE_IDX                                                                     1
#define regSWRST_CONTROL_2                                                                              0x20106
#define regSWRST_CONTROL_2_BASE_IDX                                                                     1
#define regSWRST_CONTROL_3                                                                              0x20107
#define regSWRST_CONTROL_3_BASE_IDX                                                                     1
#define regSWRST_CONTROL_4                                                                              0x20108
#define regSWRST_CONTROL_4_BASE_IDX                                                                     1
#define regSWRST_CONTROL_5                                                                              0x20109
#define regSWRST_CONTROL_5_BASE_IDX                                                                     1
#define regSWRST_CONTROL_6                                                                              0x2010a
#define regSWRST_CONTROL_6_BASE_IDX                                                                     1
#define regSWRST_EP_COMMAND_0                                                                           0x2010b
#define regSWRST_EP_COMMAND_0_BASE_IDX                                                                  1
#define regSWRST_EP_CONTROL_0                                                                           0x2010c
#define regSWRST_EP_CONTROL_0_BASE_IDX                                                                  1
#define regCPM_CONTROL                                                                                  0x20118
#define regCPM_CONTROL_BASE_IDX                                                                         1
#define regCPM_SPLIT_CONTROL                                                                            0x20119
#define regCPM_SPLIT_CONTROL_BASE_IDX                                                                   1
#define regCPM_CONTROL_EXT                                                                              0x2011a
#define regCPM_CONTROL_EXT_BASE_IDX                                                                     1
#define regCLKREQB_PAD_CNTL                                                                             0x2011b
#define regCLKREQB_PAD_CNTL_BASE_IDX                                                                    1
#define regSMN_APERTURE_ID_A                                                                            0x2011d
#define regSMN_APERTURE_ID_A_BASE_IDX                                                                   1
#define regSMN_APERTURE_ID_B                                                                            0x2011e
#define regSMN_APERTURE_ID_B_BASE_IDX                                                                   1
#define regLNCNT_CONTROL                                                                                0x20125
#define regLNCNT_CONTROL_BASE_IDX                                                                       1
#define regSMU_INT_PIN_SHARING_PORT_INDICATOR                                                           0x2012f
#define regSMU_INT_PIN_SHARING_PORT_INDICATOR_BASE_IDX                                                  1
#define regPCIE_PGMST_CNTL                                                                              0x20130
#define regPCIE_PGMST_CNTL_BASE_IDX                                                                     1
#define regPCIE_PGSLV_CNTL                                                                              0x20131
#define regPCIE_PGSLV_CNTL_BASE_IDX                                                                     1
#define regLC_CPM_CONTROL_0                                                                             0x20133
#define regLC_CPM_CONTROL_0_BASE_IDX                                                                    1
#define regLC_CPM_CONTROL_1                                                                             0x20134
#define regLC_CPM_CONTROL_1_BASE_IDX                                                                    1
#define regPCIE_RXMARGIN_CONTROL_CAPABILITIES                                                           0x20135
#define regPCIE_RXMARGIN_CONTROL_CAPABILITIES_BASE_IDX                                                  1
#define regPCIE_RXMARGIN_1_SETTINGS                                                                     0x20136
#define regPCIE_RXMARGIN_1_SETTINGS_BASE_IDX                                                            1
#define regPCIE_RXMARGIN_2_SETTINGS                                                                     0x20137
#define regPCIE_RXMARGIN_2_SETTINGS_BASE_IDX                                                            1
#define regPCIE_LC_DEBUG_CNTL                                                                           0x20139
#define regPCIE_LC_DEBUG_CNTL_BASE_IDX                                                                  1
#define regSMU_INT_PIN_SHARING_PORT_INDICATOR_TWO                                                       0x2013a
#define regSMU_INT_PIN_SHARING_PORT_INDICATOR_TWO_BASE_IDX                                              1
#define regPCIE_LC_DESKEW_CNTL                                                                          0x20150
#define regPCIE_LC_DESKEW_CNTL_BASE_IDX                                                                 1
#define regPCIE_TX_LAST_TLP0                                                                            0x20180
#define regPCIE_TX_LAST_TLP0_BASE_IDX                                                                   1
#define regPCIE_TX_LAST_TLP1                                                                            0x20181
#define regPCIE_TX_LAST_TLP1_BASE_IDX                                                                   1
#define regPCIE_TX_LAST_TLP2                                                                            0x20182
#define regPCIE_TX_LAST_TLP2_BASE_IDX                                                                   1
#define regPCIE_TX_LAST_TLP3                                                                            0x20183
#define regPCIE_TX_LAST_TLP3_BASE_IDX                                                                   1
#define regPCIE_TX_TRACKING_ADDR_LO                                                                     0x20184
#define regPCIE_TX_TRACKING_ADDR_LO_BASE_IDX                                                            1
#define regPCIE_TX_TRACKING_ADDR_HI                                                                     0x20185
#define regPCIE_TX_TRACKING_ADDR_HI_BASE_IDX                                                            1
#define regPCIE_TX_TRACKING_CTRL_STATUS                                                                 0x20186
#define regPCIE_TX_TRACKING_CTRL_STATUS_BASE_IDX                                                        1
#define regPCIE_TX_CTRL_4                                                                               0x2018b
#define regPCIE_TX_CTRL_4_BASE_IDX                                                                      1
#define regPCIE_TX_STATUS                                                                               0x20194
#define regPCIE_TX_STATUS_BASE_IDX                                                                      1
#define regPCIE_TX_F0_ATTR_CNTL                                                                         0x2019c
#define regPCIE_TX_F0_ATTR_CNTL_BASE_IDX                                                                1
#define regPCIE_TX_SWUS_ATTR_CNTL                                                                       0x2019d
#define regPCIE_TX_SWUS_ATTR_CNTL_BASE_IDX                                                              1
#define regPCIE_BW_BY_UNITID                                                                            0x201c0
#define regPCIE_BW_BY_UNITID_BASE_IDX                                                                   1
#define regPCIE_MST_CTRL_1                                                                              0x201c4
#define regPCIE_MST_CTRL_1_BASE_IDX                                                                     1
#define regPCIE_HIP_REG0                                                                                0x201e0
#define regPCIE_HIP_REG0_BASE_IDX                                                                       1
#define regPCIE_HIP_REG1                                                                                0x201e1
#define regPCIE_HIP_REG1_BASE_IDX                                                                       1
#define regPCIE_HIP_REG2                                                                                0x201e2
#define regPCIE_HIP_REG2_BASE_IDX                                                                       1
#define regPCIE_HIP_REG3                                                                                0x201e3
#define regPCIE_HIP_REG3_BASE_IDX                                                                       1
#define regPCIE_HIP_REG4                                                                                0x201e4
#define regPCIE_HIP_REG4_BASE_IDX                                                                       1
#define regPCIE_HIP_REG5                                                                                0x201e5
#define regPCIE_HIP_REG5_BASE_IDX                                                                       1
#define regPCIE_HIP_REG6                                                                                0x201e6
#define regPCIE_HIP_REG6_BASE_IDX                                                                       1
#define regPCIE_HIP_REG7                                                                                0x201e7
#define regPCIE_HIP_REG7_BASE_IDX                                                                       1
#define regPCIE_HIP_REG8                                                                                0x201e8
#define regPCIE_HIP_REG8_BASE_IDX                                                                       1
#define regPCIE_PERF_CNTL_TXCLK7                                                                        0x20222
#define regPCIE_PERF_CNTL_TXCLK7_BASE_IDX                                                               1
#define regPCIE_PERF_COUNT0_TXCLK7                                                                      0x20223
#define regPCIE_PERF_COUNT0_TXCLK7_BASE_IDX                                                             1
#define regPCIE_PERF_COUNT1_TXCLK7                                                                      0x20224
#define regPCIE_PERF_COUNT1_TXCLK7_BASE_IDX                                                             1
#define regPCIE_PERF_CNTL_TXCLK8                                                                        0x20225
#define regPCIE_PERF_CNTL_TXCLK8_BASE_IDX                                                               1
#define regPCIE_PERF_COUNT0_TXCLK8                                                                      0x20226
#define regPCIE_PERF_COUNT0_TXCLK8_BASE_IDX                                                             1
#define regPCIE_PERF_COUNT1_TXCLK8                                                                      0x20227
#define regPCIE_PERF_COUNT1_TXCLK8_BASE_IDX                                                             1
#define regPCIE_PERF_CNTL_TXCLK9                                                                        0x20228
#define regPCIE_PERF_CNTL_TXCLK9_BASE_IDX                                                               1
#define regPCIE_PERF_COUNT0_TXCLK9                                                                      0x20229
#define regPCIE_PERF_COUNT0_TXCLK9_BASE_IDX                                                             1
#define regPCIE_PERF_COUNT1_TXCLK9                                                                      0x2022a
#define regPCIE_PERF_COUNT1_TXCLK9_BASE_IDX                                                             1
#define regPCIE_PERF_CNTL_TXCLK10                                                                       0x2022b
#define regPCIE_PERF_CNTL_TXCLK10_BASE_IDX                                                              1
#define regPCIE_PERF_COUNT0_TXCLK10                                                                     0x2022c
#define regPCIE_PERF_COUNT0_TXCLK10_BASE_IDX                                                            1
#define regPCIE_PERF_COUNT1_TXCLK10                                                                     0x2022d
#define regPCIE_PERF_COUNT1_TXCLK10_BASE_IDX                                                            1
#define regPCIE_LANE_ERROR_COUNTERS_0                                                                   0x2025e
#define regPCIE_LANE_ERROR_COUNTERS_0_BASE_IDX                                                          1
#define regPCIE_LANE_ERROR_COUNTERS_1                                                                   0x2025f
#define regPCIE_LANE_ERROR_COUNTERS_1_BASE_IDX                                                          1
#define regPCIE_LANE_ERROR_COUNTERS_2                                                                   0x20260
#define regPCIE_LANE_ERROR_COUNTERS_2_BASE_IDX                                                          1
#define regPCIE_LANE_ERROR_COUNTERS_3                                                                   0x20261
#define regPCIE_LANE_ERROR_COUNTERS_3_BASE_IDX                                                          1
#define regSMU_PCIE_FENCED1_REG                                                                         0x20ffe
#define regSMU_PCIE_FENCED1_REG_BASE_IDX                                                                1
#define regSMU_PCIE_FENCED2_REG                                                                         0x20fff
#define regSMU_PCIE_FENCED2_REG_BASE_IDX                                                                1


#endif
