
/*
 *
 Copyright (c) Eicon Networks, 2002.
 *
 This source file is supplied for the use with
 Eicon Networks range of DIVA Server Adapters.
 *
 Eicon File Revision :    2.1
 *
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 *
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY OF ANY KIND WHATSOEVER INCLUDING ANY
 implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.
 *
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef _CARDTYPE_H_
#define _CARDTYPE_H_
#ifndef CARDTYPE_H_WANT_DATA
#define CARDTYPE_H_WANT_DATA   0
#endif
#ifndef CARDTYPE_H_WANT_IDI_DATA
#define CARDTYPE_H_WANT_IDI_DATA  0
#endif
#ifndef CARDTYPE_H_WANT_RESOURCE_DATA
#define CARDTYPE_H_WANT_RESOURCE_DATA 1
#endif
#ifndef CARDTYPE_H_WANT_FILE_DATA
#define CARDTYPE_H_WANT_FILE_DATA  1
#endif
/*
 * D-channel protocol identifiers
 *
 * Attention: Unfortunately the identifiers defined here differ from
 *      the identifiers used in Protocol/1/Common/prot/q931.h .
 *     The only reason for this is that q931.h has not a global
 *     scope and we did not know about the definitions there.
 *     But the definitions here cannot be changed easily because
 *     they are used in setup scripts and programs.
 *     Thus the definitions here have to be mapped if they are
 *     used in the protocol code context !
 *
 * Now the identifiers are defined in the q931lib/constant.h file.
 * Unfortunately this file has also not a global scope.
 * But beginning with PROTTYPE_US any new identifier will get the same
 * value as the corresponding PROT_* definition in q931lib/constant.h !
 */
#define PROTTYPE_MINVAL     0
#define PROTTYPE_ETSI       0
#define PROTTYPE_1TR6       1
#define PROTTYPE_BELG       2
#define PROTTYPE_FRANC      3
#define PROTTYPE_ATEL       4
#define PROTTYPE_NI         5  /* DMS 100, Nortel, National ISDN */
#define PROTTYPE_5ESS       6  /* 5ESS   , AT&T,   5ESS Custom   */
#define PROTTYPE_JAPAN      7
#define PROTTYPE_SWED       8
#define PROTTYPE_US         9  /* US autodetect */
#define PROTTYPE_ITALY      10
#define PROTTYPE_TWAN       11
#define PROTTYPE_AUSTRAL    12
#define PROTTYPE_4ESDN      13
#define PROTTYPE_4ESDS      14
#define PROTTYPE_4ELDS      15
#define PROTTYPE_4EMGC      16
#define PROTTYPE_4EMGI      17
#define PROTTYPE_HONGKONG   18
#define PROTTYPE_RBSCAS     19
#define PROTTYPE_CORNETN    20
#define PROTTYPE_QSIG       21
#define PROTTYPE_NI_EWSD    22 /* EWSD, Siemens, National ISDN   */
#define PROTTYPE_5ESS_NI    23 /* 5ESS, Lucent, National ISDN    */
#define PROTTYPE_T1CORNETN  24
#define PROTTYPE_CORNETNQ   25
#define PROTTYPE_T1CORNETNQ 26
#define PROTTYPE_T1QSIG     27
#define PROTTYPE_E1UNCH     28
#define PROTTYPE_T1UNCH     29
#define PROTTYPE_E1CHAN     30
#define PROTTYPE_T1CHAN     31
#define PROTTYPE_R2CAS      32
#define PROTTYPE_MAXVAL     32
/*
 * Card type identifiers
 */
#define CARD_UNKNOWN                      0
#define CARD_NONE                         0
/* DIVA cards */
#define CARDTYPE_DIVA_MCA                 0
#define CARDTYPE_DIVA_ISA                 1
#define CARDTYPE_DIVA_PCM                 2
#define CARDTYPE_DIVAPRO_ISA              3
#define CARDTYPE_DIVAPRO_PCM              4
#define CARDTYPE_DIVAPICO_ISA             5
#define CARDTYPE_DIVAPICO_PCM             6
/* DIVA 2.0 cards */
#define CARDTYPE_DIVAPRO20_PCI            7
#define CARDTYPE_DIVA20_PCI               8
/* S cards */
#define CARDTYPE_QUADRO_ISA               9
#define CARDTYPE_S_ISA                    10
#define CARDTYPE_S_MCA                    11
#define CARDTYPE_SX_ISA                   12
#define CARDTYPE_SX_MCA                   13
#define CARDTYPE_SXN_ISA                  14
#define CARDTYPE_SXN_MCA                  15
#define CARDTYPE_SCOM_ISA                 16
#define CARDTYPE_SCOM_MCA                 17
#define CARDTYPE_PR_ISA                   18
#define CARDTYPE_PR_MCA                   19
/* Diva Server cards (formerly called Maestra, later Amadeo) */
#define CARDTYPE_MAESTRA_ISA              20
#define CARDTYPE_MAESTRA_PCI              21
/* Diva Server cards to be developed (Quadro, Primary rate) */
#define CARDTYPE_DIVASRV_Q_8M_PCI         22
#define CARDTYPE_DIVASRV_P_30M_PCI        23
#define CARDTYPE_DIVASRV_P_2M_PCI         24
#define CARDTYPE_DIVASRV_P_9M_PCI         25
/* DIVA 2.0 cards */
#define CARDTYPE_DIVA20_ISA               26
#define CARDTYPE_DIVA20U_ISA              27
#define CARDTYPE_DIVA20U_PCI              28
#define CARDTYPE_DIVAPRO20_ISA            29
#define CARDTYPE_DIVAPRO20U_ISA           30
#define CARDTYPE_DIVAPRO20U_PCI           31
/* DIVA combi cards (piccola ISDN + rockwell V.34 modem) */
#define CARDTYPE_DIVAMOBILE_PCM           32
#define CARDTYPE_TDKGLOBALPRO_PCM         33
/* DIVA Pro PC OEM card for 'New Media Corporation' */
#define CARDTYPE_NMC_DIVAPRO_PCM          34
/* DIVA Pro 2.0 OEM cards for 'British Telecom' */
#define CARDTYPE_BT_EXLANE_PCI            35
#define CARDTYPE_BT_EXLANE_ISA            36
/* DIVA low cost cards, 1st name DIVA 3.0, 2nd DIVA 2.01, 3rd ??? */
#define CARDTYPE_DIVALOW_ISA              37
#define CARDTYPE_DIVALOWU_ISA             38
#define CARDTYPE_DIVALOW_PCI              39
#define CARDTYPE_DIVALOWU_PCI             40
/* DIVA combi cards (piccola ISDN + rockwell V.90 modem) */
#define CARDTYPE_DIVAMOBILE_V90_PCM       41
#define CARDTYPE_TDKGLOBPRO_V90_PCM       42
#define CARDTYPE_DIVASRV_P_23M_PCI        43
#define CARDTYPE_DIVALOW_USB              44
/* DIVA Audio (CT) family */
#define CARDTYPE_DIVA_CT_ST               45
#define CARDTYPE_DIVA_CT_U                46
#define CARDTYPE_DIVA_CTLITE_ST           47
#define CARDTYPE_DIVA_CTLITE_U            48
/* DIVA ISDN plus V.90 series */
#define CARDTYPE_DIVAISDN_V90_PCM         49
#define CARDTYPE_DIVAISDN_V90_PCI         50
#define CARDTYPE_DIVAISDN_TA              51
/* DIVA Server Voice cards */
#define CARDTYPE_DIVASRV_VOICE_Q_8M_PCI   52
/* DIVA Server V2 cards */
#define CARDTYPE_DIVASRV_Q_8M_V2_PCI      53
#define CARDTYPE_DIVASRV_P_30M_V2_PCI     54
/* DIVA Server Voice V2 cards */
#define CARDTYPE_DIVASRV_VOICE_Q_8M_V2_PCI 55
#define CARDTYPE_DIVASRV_VOICE_P_30M_V2_PCI 56
/* Diva LAN */
#define CARDTYPE_DIVAISDN_LAN             57
#define CARDTYPE_DIVA_202_PCI_ST          58
#define CARDTYPE_DIVA_202_PCI_U           59
#define CARDTYPE_DIVASRV_B_2M_V2_PCI      60
#define CARDTYPE_DIVASRV_B_2F_PCI         61
#define CARDTYPE_DIVALOW_USBV2            62
#define CARDTYPE_DIVASRV_VOICE_B_2M_V2_PCI 63
#define CARDTYPE_DIVA_PRO_30_PCI_ST       64
#define CARDTYPE_DIVA_CT_ST_V20           65
/* Diva Mobile V.90 PC Card and Diva ISDN PC Card */
#define CARDTYPE_DIVAMOBILE_V2_PCM        66
#define CARDTYPE_DIVA_V2_PCM              67
/* Re-badged Diva Pro PC Card */
#define CARDTYPE_DIVA_PC_CARD             68
/* next free card type identifier */
#define CARDTYPE_MAX                      69
/*
 * The card families
 */
#define FAMILY_DIVA   1
#define FAMILY_S   2
#define FAMILY_MAESTRA  3
#define FAMILY_MAX   4
/*
 * The basic card types
 */
#define CARD_DIVA           1  /* DSP based, old DSP */
#define CARD_PRO            2  /* DSP based, new DSP */
#define CARD_PICO           3  /* HSCX based   */
#define CARD_S    4  /* IDI on board based */
#define CARD_SX    5  /* IDI on board based */
#define CARD_SXN   6  /* IDI on board based */
#define CARD_SCOM   7  /* IDI on board based */
#define CARD_QUAD   8  /* IDI on board based */
#define CARD_PR    9  /* IDI on board based */
#define CARD_MAE         10  /* IDI on board based */
#define CARD_MAEQ        11  /* IDI on board based */
#define CARD_MAEP        12  /* IDI on board based */
#define CARD_DIVALOW  13  /* IPAC based   */
#define CARD_CT    14  /* SCOUT based          */
#define CARD_DIVATA   15  /* DIVA TA