/*
 * linux/include/asm-arm/arch-iop3xx/irqs.h
 *
 * Author:	Dave Jiang (dave.jiang@intel.com)
 * Copyright:	(C) 2003 Intel Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef _IOP331_IRQS_H_
#define _IOP331_IRQS_H_

/*
 * IOP80331 chipset interrupts
 */
#define IOP331_IRQ_OFS		0
#define IOP331_IRQ(x)		(IOP331_IRQ_OFS + (x))

/*
 * On IRQ or FIQ register
 */
#define IRQ_IOP331_DMA0_EOT	IOP331_IRQ(0)
#define IRQ_IOP331_DMA0_EOC	IOP331_IRQ(1)
#define IRQ_IOP331_DMA1_EOT	IOP331_IRQ(2)
#define IRQ_IOP331_DMA1_EOC	IOP331_IRQ(3)
#define IRQ_IOP331_RSVD_4	IOP331_IRQ(4)
#define IRQ_IOP331_RSVD_5	IOP331_IRQ(5)
#define IRQ_IOP331_AA_EOT	IOP331_IRQ(6)
#define IRQ_IOP331_AA_EOC	IOP331_IRQ(7)
#define IRQ_IOP331_TIMER0	IOP331_IRQ(8)
#define IRQ_IOP331_TIMER1	IOP331_IRQ(9)
#define IRQ_IOP331_I2C_0	IOP331_IRQ(10)
#define IRQ_IOP331_I2C_1	IOP331_IRQ(11)
#define IRQ_IOP331_MSG	    IOP331_IRQ(12)
#define IRQ_IOP331_MSGIBQ   IOP331_IRQ(13)
#define IRQ_IOP331_ATU_BIST	IOP331_IRQ(14)
#define IRQ_IOP331_PERFMON	IOP331_IRQ(15)
#define IRQ_IOP331_CORE_PMU	IOP331_IRQ(16)
#define IRQ_IOP331_RSVD_17	IOP331_IRQ(17)
#define IRQ_IOP331_RSVD_18	IOP331_IRQ(18)
#define IRQ_IOP331_RSVD_19	IOP331_IRQ(19)
#define IRQ_IOP331_RSVD_20	IOP331_IRQ(20)
#define IRQ_IOP331_RSVD_21	IOP331_IRQ(21)
#define IRQ_IOP331_RSVD_22	IOP331_IRQ(22)
#define IRQ_IOP331_RSVD_23	IOP331_IRQ(23)
#define IRQ_IOP331_XINT0	IOP331_IRQ(24)
#define IRQ_IOP331_XINT1	IOP331_IRQ(25)
#define IRQ_IOP331_XINT2	IOP331_IRQ(26)
#define IRQ_IOP331_XINT3	IOP331_IRQ(27)
#define IRQ_IOP331_RSVD_28  IOP331_IRQ(28)
#define IRQ_IOP331_RSVD_29  IOP331_IRQ(29)
#define IRQ_IOP331_RSVD_30  IOP331_IRQ(30)
#define IRQ_IOP331_RSVD_31  IOP331_IRQ(31)
#define IRQ_IOP331_XINT8    IOP331_IRQ(32)  // 0
#define IRQ_IOP331_XINT9    IOP331_IRQ(33)  // 1
#define IRQ_IOP331_XINT10   IOP331_IRQ(34)  // 2
#define IRQ_IOP331_XINT11   IOP331_IRQ(35)  // 3
#define IRQ_IOP331_XINT12   IOP331_IRQ(36)  // 4
#define IRQ_IOP331_XINT13   IOP331_IRQ(37)  // 5
#define IRQ_IOP331_XINT14   IOP331_IRQ(38)  // 6
#define IRQ_IOP331_XINT15   IOP331_IRQ(39)  // 7
#define IRQ_IOP331_RSVD_40  IOP331_IRQ(40)  // 8
#define IRQ_IOP331_RSVD_41  IOP331_IRQ(41)  // 9
#define IRQ_IOP331_RSVD_42  IOP331_IRQ(42)  // 10
#define IRQ_IOP331_RSVD_43  IOP331_IRQ(43)  // 11
#define IRQ_IOP331_RSVD_44  IOP331_IRQ(44)  // 12
#define IRQ_IOP331_RSVD_45  IOP331_IRQ(45)  // 13
#define IRQ_IOP331_RSVD_46  IOP331_IRQ(46)  // 14
#define IRQ_IOP331_RSVD_47  IOP331_IRQ(47)  // 15
#define IRQ_IOP331_RSVD_48  IOP331_IRQ(48)  // 16
#define IRQ_IOP331_RSVD_49  IOP331_IRQ(49)  // 17
#define IRQ_IOP331_RSVD_50  IOP331_IRQ(50)  // 18
#define IRQ_IOP331_UART0    IOP331_IRQ(51)  // 19
#define IRQ_IOP331_UART1    IOP331_IRQ(52)  // 20
#define IRQ_IOP331_PBIE     IOP331_IRQ(53)  // 21
#define IRQ_IOP331_ATU_CRW  IOP331_IRQ(54)  // 22
#define IRQ_IOP331_ATU_ERR	IOP331_IRQ(55)  // 23
#define IRQ_IOP331_MCU_ERR	IOP331_IRQ(56)  // 24
#define IRQ_IOP331_DMA0_ERR	IOP331_IRQ(57)  // 25
#define IRQ_IOP331_DMA1_ERR	IOP331_IRQ(58)  // 26
#define IRQ_IOP331_RSVD_59  IOP331_IRQ(59)  // 27
#define IRQ_IOP331_AA_ERR	IOP331_IRQ(60)  // 28
#define IRQ_IOP331_RSVD_61  IOP331_IRQ(61)  // 29
#define IRQ_IOP331_MSG_ERR	IOP331_IRQ(62)  // 30
#define IRQ_IOP331_HPI		IOP331_IRQ(63)  // 31

#define NR_IOP331_IRQS		(IOP331_IRQ(63) + 1)

#define NR_IRQS			NR_IOP331_IRQS


/*
 * Interrupts available on the IQ80331 board
 */

/*
 * On board devices
 */
#define	IRQ_IQ80331_I82544	IRQ_IOP331_XINT0
#define IRQ_IQ80331_UART0	IRQ_IOP331_UART0
#define IRQ_IQ80331_UART1	IRQ_IOP331_UART1

/*
 * PCI interrupts
 */
#define	IRQ_IQ80331_INTA	IRQ_IOP331_XINT0
#define	IRQ_IQ80331_INTB	IRQ_IOP331_XINT1
#define	IRQ_IQ80331_INTC	IRQ_IOP331_XINT2
#define	IRQ_IQ80331_INTD	IRQ_IOP331_XINT3

#endif // _IOP331_IRQ_H_
