/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Target;
import gnu.kawa.reflect.OccurrenceType;
import gnu.mapping.Values;

public class StackTarget
extends Target {
    Type type;

    public StackTarget(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public static Target getInstance(Type type) {
        return type.isVoid() ? Target.Ignore : (type == Type.pointer_type ? Target.pushObject : new StackTarget(type));
    }

    protected boolean compileFromStack0(Compilation comp, Type stackType) {
        return StackTarget.compileFromStack0(comp, stackType, this.type);
    }

    static boolean compileFromStack0(Compilation comp, Type stackType, Type type) {
        if (type == stackType) {
            return true;
        }
        CodeAttr code = comp.getCode();
        if (stackType.isVoid()) {
            comp.compileConstant(Values.empty);
            stackType = Type.pointer_type;
        } else if (stackType instanceof PrimType && type instanceof PrimType) {
            code.emitConvert(stackType, type);
            return true;
        }
        if (stackType instanceof ArrayType) {
            if (type == Type.pointer_type || "java.lang.Cloneable".equals(type.getName())) {
                return true;
            }
        } else {
            stackType.emitCoerceToObject(code);
            stackType = code.topType();
        }
        return !CodeAttr.castNeeded(stackType, type);
    }

    public static void convert(Compilation comp, Type stackType, Type targetType) {
        if (!StackTarget.compileFromStack0(comp, stackType, targetType)) {
            StackTarget.emitCoerceFromObject(targetType, comp);
        }
    }

    protected static void emitCoerceFromObject(Type type, Compilation comp) {
        CodeAttr code = comp.getCode();
        if (type instanceof OccurrenceType) {
            comp.compileConstant(type, Target.pushObject);
            code.emitSwap();
            code.emitInvokeVirtual(ClassType.make("gnu.bytecode.Type").getDeclaredMethod("coerceFromObject", 1));
        } else {
            comp.usedClass(type);
            type.emitCoerceFromObject(code);
        }
    }

    public void compileFromStack(Compilation comp, Type stackType) {
        if (!this.compileFromStack0(comp, stackType)) {
            StackTarget.emitCoerceFromObject(this.type, comp);
        }
    }
}

