# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential

from ._configuration import ResourceMoverServiceAPIConfiguration
from .operations import MoveCollectionsOperations
from .operations import MoveResourcesOperations
from .operations import UnresolvedDependenciesOperations
from .operations import OperationsDiscoveryOperations
from . import models


class ResourceMoverServiceAPI(object):
    """A first party Azure service orchestrating the move of Azure resources from one Azure region to another or between zones within a region.

    :ivar move_collections: MoveCollectionsOperations operations
    :vartype move_collections: resource_mover_service_api.operations.MoveCollectionsOperations
    :ivar move_resources: MoveResourcesOperations operations
    :vartype move_resources: resource_mover_service_api.operations.MoveResourcesOperations
    :ivar unresolved_dependencies: UnresolvedDependenciesOperations operations
    :vartype unresolved_dependencies: resource_mover_service_api.operations.UnresolvedDependenciesOperations
    :ivar operations_discovery: OperationsDiscoveryOperations operations
    :vartype operations_discovery: resource_mover_service_api.operations.OperationsDiscoveryOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The Subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = ResourceMoverServiceAPIConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.move_collections = MoveCollectionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.move_resources = MoveResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.unresolved_dependencies = UnresolvedDependenciesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations_discovery = OperationsDiscoveryOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> ResourceMoverServiceAPI
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
