
/* 
 *  panic.c - terminate fast in case of error
 *  Copyright (C) 1993  Thomas Koenig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* System Headers */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

/* Local headers */

#include "panic.h"
#include "at.h"

/* File scope variables */

static char rcsid[] = "$Id: panic.c,v 1.9 1993/10/16 10:16:50 kernel Exp kernel $";

/* External variables */

/* Global functions */

void
panic(char *a)
{
/* Something fatal has happened, print error message and exit.
 */
	fprintf(stderr,"%s: %s\n",namep,a);
	if (fcreated)
		unlink(atfile);

	exit (EXIT_FAILURE);
}

void
perr(char *a)
{
/* Some operating system error; print error message and exit.
 */
	perror(a);
	if (fcreated)
		unlink(atfile);

	exit(EXIT_FAILURE);
}

void
usage(void)
{
/* Print usage and exit.
*/
    fprintf(stderr, "Usage: at [-V] [-q x] [-f file] [-m] time\n"
		    "       atq [-V] [-q x] [-v]\n"
		    "       atrm [-V] [-q x] job ...\n"
		    "       batch [-V] [-f file] [-m]\n");
    exit(EXIT_FAILURE);
}
