/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariableReference;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingAnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNodeVisitor;

public class ExactAnnotationTypePattern
extends AnnotationTypePattern {
    protected UnresolvedType annotationType;
    protected String formalName;
    protected boolean resolved = false;
    private boolean bindingPattern = false;
    private static byte VERSION = 1;

    public ExactAnnotationTypePattern(UnresolvedType annotationType) {
        this.annotationType = annotationType;
        this.resolved = annotationType instanceof ResolvedType;
    }

    protected ExactAnnotationTypePattern(String formalName) {
        this.formalName = formalName;
        this.resolved = false;
        this.bindingPattern = true;
    }

    public ResolvedType getResolvedAnnotationType() {
        if (!this.resolved) {
            throw new IllegalStateException("I need to be resolved first!");
        }
        return (ResolvedType)this.annotationType;
    }

    public UnresolvedType getAnnotationType() {
        return this.annotationType;
    }

    public FuzzyBoolean fastMatches(AnnotatedElement annotated) {
        if (annotated.hasAnnotation(this.annotationType)) {
            return FuzzyBoolean.YES;
        }
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean matches(AnnotatedElement annotated) {
        boolean checkSupers = false;
        if (this.getResolvedAnnotationType().hasAnnotation(UnresolvedType.AT_INHERITED) && annotated instanceof ResolvedType) {
            checkSupers = true;
        }
        if (annotated.hasAnnotation(this.annotationType)) {
            ReferenceType rt;
            if (this.annotationType instanceof ReferenceType && (rt = (ReferenceType)this.annotationType).getRetentionPolicy() != null && rt.getRetentionPolicy().equals("SOURCE")) {
                rt.getWorld().getMessageHandler().handleMessage(MessageUtil.warn(WeaverMessages.format("noMatchBecauseSourceRetention", this.annotationType, annotated), this.getSourceLocation()));
                return FuzzyBoolean.NO;
            }
            return FuzzyBoolean.YES;
        }
        if (checkSupers) {
            for (ResolvedType toMatchAgainst = ((ResolvedType)annotated).getSuperclass(); toMatchAgainst != null; toMatchAgainst = toMatchAgainst.getSuperclass()) {
                if (!toMatchAgainst.hasAnnotation(this.annotationType)) continue;
                return FuzzyBoolean.YES;
            }
        }
        return FuzzyBoolean.NO;
    }

    public FuzzyBoolean matchesRuntimeType(AnnotatedElement annotated) {
        if (this.getResolvedAnnotationType().hasAnnotation(UnresolvedType.AT_INHERITED) && this.matches(annotated).alwaysTrue()) {
            return FuzzyBoolean.YES;
        }
        return FuzzyBoolean.MAYBE;
    }

    public void resolve(World world) {
        if (!this.resolved) {
            this.annotationType = this.annotationType.resolve(world);
        }
        this.resolved = true;
    }

    public AnnotationTypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding) {
        FormalBinding formalBinding;
        if (this.resolved) {
            return this;
        }
        this.resolved = true;
        String simpleName = this.maybeGetSimpleName();
        if (simpleName != null && (formalBinding = scope.lookupFormal(simpleName)) != null) {
            if (bindings == null) {
                scope.message(IMessage.ERROR, this, "negation doesn't allow binding");
                return this;
            }
            if (!allowBinding) {
                scope.message(IMessage.ERROR, this, "name binding only allowed in @pcds, args, this, and target");
                return this;
            }
            this.formalName = simpleName;
            this.bindingPattern = true;
            this.verifyIsAnnotationType(formalBinding.getType().resolve(scope.getWorld()), scope);
            BindingAnnotationTypePattern binding = new BindingAnnotationTypePattern(formalBinding);
            binding.copyLocationFrom(this);
            bindings.register(binding, scope);
            binding.resolveBinding(scope.getWorld());
            return binding;
        }
        String cleanname = this.annotationType.getName();
        this.annotationType = scope.getWorld().resolve(this.annotationType, true);
        if (ResolvedType.isMissing(this.annotationType)) {
            int lastDot;
            UnresolvedType type = null;
            while (ResolvedType.isMissing(type = scope.lookupType(cleanname, this)) && (lastDot = cleanname.lastIndexOf(46)) != -1) {
                cleanname = cleanname.substring(0, lastDot) + "$" + cleanname.substring(lastDot + 1);
            }
            this.annotationType = scope.getWorld().resolve(type, true);
        }
        this.verifyIsAnnotationType((ResolvedType)this.annotationType, scope);
        return this;
    }

    public AnnotationTypePattern parameterizeWith(Map typeVariableMap, World w) {
        UnresolvedType newAnnotationType = this.annotationType;
        if (this.annotationType.isTypeVariableReference()) {
            TypeVariableReference t = (TypeVariableReference)((Object)this.annotationType);
            String key = t.getTypeVariable().getName();
            if (typeVariableMap.containsKey(key)) {
                newAnnotationType = (UnresolvedType)typeVariableMap.get(key);
            }
        } else if (this.annotationType.isParameterizedType()) {
            newAnnotationType = this.annotationType.parameterize(typeVariableMap);
        }
        ExactAnnotationTypePattern ret = new ExactAnnotationTypePattern(newAnnotationType);
        ret.formalName = this.formalName;
        ret.bindingPattern = this.bindingPattern;
        ret.copyLocationFrom(this);
        return ret;
    }

    private String maybeGetSimpleName() {
        if (this.formalName != null) {
            return this.formalName;
        }
        String ret = this.annotationType.getName();
        return ret.indexOf(46) == -1 ? ret : null;
    }

    private void verifyIsAnnotationType(ResolvedType type, IScope scope) {
        if (!type.isAnnotation()) {
            IMessage m = MessageUtil.error(WeaverMessages.format("referenceToNonAnnotationType", type.getName()), this.getSourceLocation());
            scope.getWorld().getMessageHandler().handleMessage(m);
            this.resolved = false;
        }
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(1);
        s.writeByte(VERSION);
        s.writeBoolean(this.bindingPattern);
        if (this.bindingPattern) {
            s.writeUTF(this.formalName);
        } else {
            this.annotationType.write(s);
        }
        this.writeLocation(s);
    }

    public static AnnotationTypePattern read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        byte version = s.readByte();
        if (version > VERSION) {
            throw new BCException("ExactAnnotationTypePattern was written by a newer version of AspectJ");
        }
        boolean isBindingPattern = s.readBoolean();
        ExactAnnotationTypePattern ret = isBindingPattern ? new ExactAnnotationTypePattern(s.readUTF()) : new ExactAnnotationTypePattern(UnresolvedType.read(s));
        ret.readLocation(context, s);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExactAnnotationTypePattern)) {
            return false;
        }
        ExactAnnotationTypePattern other = (ExactAnnotationTypePattern)obj;
        return other.annotationType.equals(this.annotationType);
    }

    public int hashCode() {
        return this.annotationType.hashCode();
    }

    public String toString() {
        if (!this.resolved && this.formalName != null) {
            return this.formalName;
        }
        String ret = "@" + this.annotationType.toString();
        if (this.formalName != null) {
            ret = ret + " " + this.formalName;
        }
        return ret;
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

