proc constrainedRandomVectors {vectorsNeeded meanVector sdevVector} {

  set dimension [llength $meanVector]
  for {set vectorsMade 0} {$vectorsMade < $vectorsNeeded} {incr vectorsMade} {
    for {set position 0} {$position < $dimension} {incr position} {
      set  sdev [lindex   $sdevVector $position]
      set  mean [lindex   $meanVector $position]
      set  R [NUMBER floatRandom   $sdev ]
      # each position of the random vector is either plus or minus the mean.
      # we generate a random number to determine whether to add or subtract R
      # from the mean
      set  Q [random   100 ]
      # if Q > 50 then add R to the mean, otherwise subtract
      if {$Q <= 50} {set element [expr $mean-$R]} {set element [expr $mean+$R]}
      lvarcat randomVector $element
    }
    lvarpush retval $randomVector
    unset randomVector
  }
  return $retval
}


proc vsumElements vector {
  set sum 0 ;
  foreach element $vector {
    set sum [expr $element+$sum]
  }
  return $sum ;
}

# requires extended Tcl
proc vsumListOfVectors vectors {
set x {}
for {set i 0} {$i <= [llength [lindex $vectors 0]]} {incr i} {
  lappend x 0.0
}
  foreach vector $vectors {
    set x [vsum $vector $x]
  }
  return $x
}

proc vsum {vec1 vec2} {
  set x {} 
  set count 0 ;
  foreach element $vec1 {
    lappend x [expr $element+[lindex $vec2 $count]] ;
    incr count ;
  }
  return $x
}
   
proc vscalarMultiply {vec1 scalar} {
  set x {} 
  foreach element $vec1 {
    lappend x [expr $element*$scalar] 
  }
  return $x
}

proc vaverageElements vector {
  puts "vaverage: $vector"
  set x [vsumElements $vector]
  return [vscalarMultiply $x [expr 1.0/[llength $vector]]]
}

proc vaverage vectors {
  set x [vsumListOfVectors $vectors]
  return [vscalarMultiply $x [expr 1.0/[llength $vectors]]] 
}

proc vdifference {vec1 vec2} {
  set x {} ;
  set count 0 ;
  foreach element $vec1 {
    lappend x [expr $element-[lindex $vec2 $count]] 
    incr count 
  }
return $x
}

proc vdistance {vec1 vec2} {
  set x [vdifference $vec1 $vec2] ;
  return [sqrt [vdotProduct $x $x]] ;
}

proc vdotProduct {vec1 vec2} {
  
  set i 0 ;   set sum 0 ;

  foreach element $vec1 {
    set sum [expr $element*[lindex $vec2 $i]+$sum] ;
    incr i ;
  }
  return $sum ;
}

proc vtest {} {

	set a 5
	set b 6
	expr $a+$b


}
