/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import tcl.lang.Channel;
import tcl.lang.ConsoleEvent;
import tcl.lang.Interp;
import tcl.lang.Parser;
import tcl.lang.StdChannel;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;
import tcl.lang.Var;

class ConsoleThread
extends Thread {
    Interp interp;
    Vector historyObjs;
    StringBuffer sbuf;
    private Channel in;
    private Channel out;
    private Channel err;
    private static final boolean debug = false;
    private static boolean sysInAvailableWorks;

    ConsoleThread(Interp interp) {
        this.setName("ConsoleThread");
        this.interp = interp;
        this.sbuf = new StringBuffer(100);
        this.historyObjs = new Vector();
        this.out = new StdChannel("stdout");
        this.err = new StdChannel("stderr");
    }

    public synchronized void run() {
        this.put(this.out, "% ");
        while (true) {
            TclObject tclObject;
            this.getLine();
            Object object = this.sbuf.toString();
            if (Parser.commandComplete((String)object, ((String)object).length())) {
                Object object2;
                int n;
                Object object3;
                object = new ConsoleEvent(this.interp, this.sbuf.toString());
                this.interp.getNotifier().queueEvent((TclEvent)object, 0);
                object.sync();
                if (((ConsoleEvent)((Object)object)).evalResult != null) {
                    object3 = ((ConsoleEvent)((Object)object)).evalResult.toString();
                    if (((String)object3).length() > 0) {
                        Channel channel = this.out;
                        this.put(channel, (String)object3);
                        this.put(channel, "\n");
                    }
                    n = 0;
                    try {
                        object2 = this.interp;
                        object2 = Var.getVar((Interp)object2, "historyLimit", null, 513);
                        if (object2 != null) {
                            n = TclInteger.get((Interp)this.interp, (TclObject)object2);
                        }
                    }
                    catch (TclException tclException) {}
                    if (n > 0) {
                        this.historyObjs.addElement(((ConsoleEvent)((Object)object)).evalResult);
                    } else {
                        ((ConsoleEvent)((Object)object)).evalResult.release();
                    }
                    if (this.historyObjs.size() > n && this.historyObjs.size() > 0) {
                        object2 = (TclObject)this.historyObjs.elementAt(0);
                        this.historyObjs.removeElementAt(0);
                        object2.release();
                    }
                } else {
                    object3 = ((ConsoleEvent)((Object)object)).evalException;
                    n = object3.getCompletionCode();
                    if (n != 2 || (n = this.interp.updateReturnInfo()) != 0) {
                        switch (n) {
                            case 1: {
                                object2 = this.err;
                                String string = this.interp.getResult().toString();
                                this.put((Channel)object2, string);
                                this.put((Channel)object2, "\n");
                                break;
                            }
                            case 3: {
                                object2 = this.err;
                                this.put((Channel)object2, "invoked \"break\" outside of a loop");
                                this.put((Channel)object2, "\n");
                                break;
                            }
                            case 4: {
                                object2 = this.err;
                                this.put((Channel)object2, "invoked \"continue\" outside of a loop");
                                this.put((Channel)object2, "\n");
                                break;
                            }
                            default: {
                                object2 = this.err;
                                String string = "command returned bad code: " + n;
                                this.put((Channel)object2, string);
                                this.put((Channel)object2, "\n");
                            }
                        }
                    }
                }
                this.sbuf.setLength(0);
                try {
                    object3 = this.interp;
                    tclObject = Var.getVar((Interp)object3, "tcl_prompt1", null, 513);
                }
                catch (TclException tclException) {
                    tclObject = null;
                }
                if (tclObject != null) {
                    try {
                        this.interp.eval(tclObject.toString(), 1);
                    }
                    catch (TclException tclException) {
                        this.put(this.out, "% ");
                    }
                    continue;
                }
                this.put(this.out, "% ");
                continue;
            }
            try {
                object = this.interp;
                tclObject = Var.getVar((Interp)object, "tcl_prompt2", null, 513);
            }
            catch (TclException tclException) {
                tclObject = null;
            }
            if (tclObject != null) {
                try {
                    this.interp.eval(tclObject.toString(), 1);
                }
                catch (TclException tclException) {
                    this.put(this.out, "> ");
                }
                continue;
            }
            this.put(this.out, "> ");
        }
    }

    private void getLine() {
        int n = -1;
        if (sysInAvailableWorks) {
            try {
                n = 0;
                while (n == 0) {
                    n = System.in.available();
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                System.exit(0);
            }
            catch (EOFException eOFException) {
                System.exit(0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
        }
        char c = ' ';
        char c2 = ' ';
        while (n != 0) {
            try {
                int n2 = System.in.read();
                if (n2 == -1) {
                    if (this.sbuf.length() == 0) {
                        System.exit(0);
                    } else {
                        return;
                    }
                }
                c2 = (char)n2;
                --n;
                if (c2 == '\r') {
                    n2 = System.in.read();
                    if (n2 == -1) {
                        if (this.sbuf.length() == 0) {
                            System.exit(0);
                        } else {
                            return;
                        }
                    }
                    if ((c = (char)((char)n2)) == '\n') {
                        c2 = c;
                    } else {
                        this.sbuf.append(c2);
                        c2 = c;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
            this.sbuf.append(c2);
            if (c2 != 10) continue;
            return;
        }
    }

    private void putLine(Channel channel, String string) {
        this.put(channel, string);
        this.put(channel, "\n");
    }

    private void put(Channel channel, String string) {
        try {
            this.out.write(this.interp, string);
            this.out.flush(this.interp);
            return;
        }
        catch (Exception exception) {
            throw new TclRuntimeError("unexpected Exception " + exception);
        }
    }

    static {
        try {
            System.in.available();
            sysInAvailableWorks = true;
        }
        catch (Exception exception) {}
        if (Util.isWindows()) {
            sysInAvailableWorks = false;
        }
    }
}

