/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import tcl.lang.Command;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.JACL;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

class FileCmd
implements Command {
    static Class procClass = null;
    private static final String[] validCmds = new String[]{"atime", "attributes", "copy", "delete", "dirname", "executable", "exists", "extension", "isdirectory", "isfile", "join", "lstat", "mtime", "mkdir", "nativename", "owned", "pathtype", "readable", "readlink", "rename", "rootname", "size", "split", "stat", "tail", "type", "volumes", "writable"};
    private static final int OPT_ATIME = 0;
    private static final int OPT_ATTRIBUTES = 1;
    private static final int OPT_COPY = 2;
    private static final int OPT_DELETE = 3;
    private static final int OPT_DIRNAME = 4;
    private static final int OPT_EXECUTABLE = 5;
    private static final int OPT_EXISTS = 6;
    private static final int OPT_EXTENSION = 7;
    private static final int OPT_ISDIRECTORY = 8;
    private static final int OPT_ISFILE = 9;
    private static final int OPT_JOIN = 10;
    private static final int OPT_LSTAT = 11;
    private static final int OPT_MTIME = 12;
    private static final int OPT_MKDIR = 13;
    private static final int OPT_NATIVENAME = 14;
    private static final int OPT_OWNED = 15;
    private static final int OPT_PATHTYPE = 16;
    private static final int OPT_READABLE = 17;
    private static final int OPT_READLINK = 18;
    private static final int OPT_RENAME = 19;
    private static final int OPT_ROOTNAME = 20;
    private static final int OPT_SIZE = 21;
    private static final int OPT_SPLIT = 22;
    private static final int OPT_STAT = 23;
    private static final int OPT_TAIL = 24;
    private static final int OPT_TYPE = 25;
    private static final int OPT_VOLUMES = 26;
    private static final int OPT_WRITABLE = 27;
    private static final String[] validOptions = new String[]{"-force", "--"};
    private static final int OPT_FORCE = 0;
    private static final int OPT_LAST = 1;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 1, argv, "option name ?arg ...?");
        }
        int opt = TclIndex.get((Interp)interp, (TclObject)argv[1], (String[])validCmds, (String)"option", (int)0);
        File fileObj = null;
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                interp.setResult(FileCmd.getMtime(interp, argv[2].toString(), fileObj));
                return;
            }
            case 1: {
                throw new TclException(interp, "sorry, \"file attributes\" is not implemented yet");
            }
            case 2: {
                FileCmd.fileCopyRename(interp, argv, true);
                return;
            }
            case 3: {
                FileCmd.fileDelete(interp, argv);
                return;
            }
            case 4: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                String path = argv[2].toString();
                TclObject[] splitArrayObj = TclList.getElements(interp, FileUtil.splitAndTranslate(interp, path));
                if (splitArrayObj.length > 1) {
                    interp.setResult(FileUtil.joinPath(interp, splitArrayObj, 0, splitArrayObj.length - 1));
                } else if (splitArrayObj.length == 0 || FileUtil.getPathType(path) == 0) {
                    if (JACL.PLATFORM == 2) {
                        interp.setResult(":");
                    } else {
                        interp.setResult(".");
                    }
                } else {
                    interp.setResult(splitArrayObj[0].toString());
                }
                return;
            }
            case 5: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                boolean isExe = false;
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                if (fileObj.exists()) {
                    String fileName;
                    isExe = fileObj.isDirectory();
                    if (isExe) {
                        interp.setResult(isExe);
                        return;
                    }
                    isExe = Util.isWindows() ? (fileName = argv[2].toString()).endsWith(".exe") || fileName.endsWith(".com") || fileName.endsWith(".bat") : (Util.isMac() ? true : true);
                }
                interp.setResult(isExe);
                return;
            }
            case 6: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                interp.setResult(fileObj.exists());
                return;
            }
            case 7: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                interp.setResult(FileCmd.getExtension(argv[2].toString()));
                return;
            }
            case 8: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                interp.setResult(fileObj.isDirectory());
                return;
            }
            case 9: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                interp.setResult(fileObj.isFile());
                return;
            }
            case 10: {
                interp.setResult(FileUtil.joinPath(interp, argv, 2, argv.length));
                return;
            }
            case 11: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 2, argv, "name varName");
                }
                throw new TclException(interp, "file command with opt " + argv[1].toString() + " is not yet implemented");
            }
            case 12: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                interp.setResult(FileCmd.getMtime(interp, argv[2].toString(), fileObj));
                return;
            }
            case 13: {
                FileCmd.fileMakeDirs(interp, argv);
                return;
            }
            case 14: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                interp.setResult(FileUtil.translateFileName(interp, argv[2].toString()));
                return;
            }
            case 15: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                interp.setResult(FileCmd.isOwner(interp, fileObj));
                return;
            }
            case 16: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                switch (FileUtil.getPathType(argv[2].toString())) {
                    case 0: {
                        interp.setResult("relative");
                        return;
                    }
                    case 1: {
                        interp.setResult("volumerelative");
                        return;
                    }
                    case 2: {
                        interp.setResult("absolute");
                    }
                }
                return;
            }
            case 17: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                interp.setResult(fileObj.canRead());
                return;
            }
            case 18: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                throw new TclException(interp, "file command with opt " + argv[1].toString() + " is not yet implemented");
            }
            case 19: {
                FileCmd.fileCopyRename(interp, argv, false);
                return;
            }
            case 20: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                String fileName = argv[2].toString();
                String extension = FileCmd.getExtension(fileName);
                int diffLength = fileName.length() - extension.length();
                interp.setResult(fileName.substring(0, diffLength));
                return;
            }
            case 21: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                if (!fileObj.exists()) {
                    throw new TclPosixException(interp, 2, true, "could not read \"" + argv[2].toString() + "\"");
                }
                interp.setResult((int)fileObj.length());
                return;
            }
            case 22: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                interp.setResult(FileUtil.splitPath(interp, argv[2].toString()));
                return;
            }
            case 23: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 2, argv, "name varName");
                }
                FileCmd.getAndStoreStatData(interp, argv[2].toString(), argv[3].toString());
                return;
            }
            case 24: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                interp.setResult(FileCmd.getTail(interp, argv[2].toString()));
                return;
            }
            case 25: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                interp.setResult(FileCmd.getType(interp, argv[2].toString(), fileObj));
                return;
            }
            case 26: {
                throw new TclException(interp, "sorry, \"file volumes\" is not implemented yet");
            }
            case 27: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "name");
                }
                fileObj = FileUtil.getNewFileObj(interp, argv[2].toString());
                interp.setResult(fileObj.canWrite());
                return;
            }
        }
        throw new TclRuntimeError("file command with opt " + argv[1].toString() + " is not implemented");
    }

    private static boolean isOwner(Interp interp, File fileObj) throws TclException {
        if (!fileObj.exists()) {
            return false;
        }
        boolean owner = true;
        Util.isUnix();
        return owner;
    }

    private static int getMtime(Interp interp, String fileName, File fileObj) throws TclException {
        if (!fileObj.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + fileName + "\"");
        }
        return (int)fileObj.lastModified();
    }

    private static String getType(Interp interp, String fileName, File fileObj) throws TclException {
        if (!fileObj.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + fileName + "\"");
        }
        if (fileObj.isFile()) {
            return "file";
        }
        if (fileObj.isDirectory()) {
            return "directory";
        }
        return "link";
    }

    private static void getAndStoreStatData(Interp interp, String fileName, String varName) throws TclException {
        File fileObj = FileUtil.getNewFileObj(interp, fileName);
        if (!fileObj.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + fileName + "\"");
        }
        try {
            int mtime = FileCmd.getMtime(interp, fileName, fileObj);
            TclObject mtimeObj = TclInteger.newInstance((int)mtime);
            TclObject atimeObj = TclInteger.newInstance((int)mtime);
            TclObject ctimeObj = TclInteger.newInstance((int)mtime);
            interp.setVar(varName, "atime", atimeObj, 0);
            interp.setVar(varName, "ctime", ctimeObj, 0);
            interp.setVar(varName, "mtime", mtimeObj, 0);
        }
        catch (SecurityException e) {
            throw new TclException(interp, e.getMessage());
        }
        catch (TclException tclException) {
            throw new TclException(interp, "can't set \"" + varName + "(dev)\": variable isn't array");
        }
        try {
            TclObject sizeObj = TclInteger.newInstance((int)((int)fileObj.length()));
            interp.setVar(varName, "size", sizeObj, 0);
        }
        catch (Exception exception) {}
        try {
            TclObject typeObj = TclString.newInstance((String)FileCmd.getType(interp, fileName, fileObj));
            interp.setVar(varName, "type", typeObj, 0);
        }
        catch (Exception exception) {}
        try {
            TclObject uidObj = TclBoolean.newInstance((boolean)FileCmd.isOwner(interp, fileObj));
            interp.setVar(varName, "uid", uidObj, 0);
        }
        catch (TclException tclException) {}
    }

    /*
     * Unable to fully structure code
     */
    private static String getExtension(String path) {
        if (path.length() < 1) {
            return "";
        }
        lastSepIndex = -1;
        switch (JACL.PLATFORM) {
            case 1: {
                tmpPath = path.replace('\\', '/').replace(':', '/');
                lastSepIndex = tmpPath.lastIndexOf(47);
                break;
            }
            case 2: {
                lastSepIndex = path.lastIndexOf(58);
                if (lastSepIndex != -1) break;
                lastSepIndex = path.lastIndexOf(47);
                break;
            }
            default: {
                lastSepIndex = path.lastIndexOf(47);
            }
        }
        if (++lastSepIndex >= path.length()) {
            return "";
        }
        lastSep = path.substring(lastSepIndex);
        dotIndex = lastSep.lastIndexOf(46);
        if (dotIndex != -1) ** GOTO lbl23
        return "";
lbl-1000:
        // 1 sources

        {
            --dotIndex;
lbl23:
            // 2 sources

            ** while (dotIndex > 0 && lastSep.charAt((int)(dotIndex - 1)) == '.')
        }
lbl24:
        // 1 sources

        return lastSep.substring(dotIndex);
    }

    private static String getTail(Interp interp, String path) throws TclException {
        TclObject splitResult = FileUtil.splitAndTranslate(interp, path);
        int last = TclList.getLength(interp, splitResult) - 1;
        if (last >= 0 && (last > 0 || FileUtil.getPathType(path) == 0)) {
            TclObject tailObj = TclList.index(interp, splitResult, last);
            return tailObj.toString();
        }
        return "";
    }

    private static void fileMakeDirs(Interp interp, TclObject[] argv) throws TclException {
        boolean madeDir = false;
        int currentDir = 2;
        while (currentDir < argv.length) {
            String dirName = argv[currentDir].toString();
            if (dirName.length() == 0) {
                throw new TclPosixException(interp, 2, true, "can't create directory \"\"");
            }
            File dirObj = FileUtil.getNewFileObj(interp, dirName);
            if (dirObj.exists()) {
                if (!dirObj.isDirectory()) {
                    throw new TclPosixException(interp, 17, true, "can't create directory \"" + dirName + "\"");
                }
            } else {
                try {
                    madeDir = dirObj.mkdir();
                    if (!madeDir) {
                        madeDir = dirObj.mkdirs();
                    }
                }
                catch (SecurityException e) {
                    throw new TclException(interp, e.getMessage());
                }
                if (!madeDir) {
                    throw new TclPosixException(interp, 13, true, "can't create directory \"" + dirName + "\":  best guess at reason");
                }
            }
            ++currentDir;
        }
    }

    private static void fileDelete(Interp interp, TclObject[] argv) throws TclException {
        boolean force = false;
        int firstSource = 2;
        boolean last = false;
        while (firstSource < argv.length && !last) {
            if (!argv[firstSource].toString().startsWith("-")) break;
            int opt = TclIndex.get((Interp)interp, (TclObject)argv[firstSource], (String[])validOptions, (String)"option", (int)1);
            switch (opt) {
                case 0: {
                    force = true;
                    break;
                }
                case 1: {
                    last = true;
                    break;
                }
                default: {
                    throw new TclRuntimeError("FileCmd.cmdProc: bad option " + opt + " index to validOptions");
                }
            }
            ++firstSource;
        }
        if (firstSource >= argv.length) {
            throw new TclNumArgsException(interp, 2, argv, "?options? file ?file ...?");
        }
        int i = firstSource;
        while (i < argv.length) {
            FileCmd.deleteOneFile(interp, argv[i].toString(), force);
            ++i;
        }
    }

    private static void deleteOneFile(Interp interp, String fileName, boolean force) throws TclException {
        boolean isDeleted = true;
        File fileObj = FileUtil.getNewFileObj(interp, fileName);
        if (!fileObj.exists() || fileName.length() == 0) {
            return;
        }
        if (fileObj.isDirectory() && fileObj.list().length > 0) {
            if (force) {
                String[] fileList = fileObj.list();
                int i = 0;
                while (i < fileList.length) {
                    TclObject[] joinArrayObj = new TclObject[]{TclString.newInstance((String)fileName), TclString.newInstance((String)fileList[i])};
                    String child = FileUtil.joinPath(interp, joinArrayObj, 0, 2);
                    FileCmd.deleteOneFile(interp, child, force);
                    ++i;
                }
            } else {
                throw new TclPosixException(interp, 66, "error deleting \"" + fileName + "\": directory not empty");
            }
        }
        try {
            isDeleted = fileObj.delete();
        }
        catch (SecurityException e) {
            throw new TclException(interp, e.getMessage());
        }
        if (!isDeleted) {
            throw new TclPosixException(interp, 13, true, "error deleting \"" + fileName + "\":  best guess at reason");
        }
    }

    private static void fileCopyRename(Interp interp, TclObject[] argv, boolean copyFlag) throws TclException {
        int firstSource = 2;
        boolean force = false;
        boolean last = false;
        while (firstSource < argv.length && !last) {
            if (!argv[firstSource].toString().startsWith("-")) break;
            int opt = TclIndex.get((Interp)interp, (TclObject)argv[firstSource], (String[])validOptions, (String)"option", (int)1);
            switch (opt) {
                case 0: {
                    force = true;
                    break;
                }
                case 1: {
                    last = true;
                    break;
                }
                default: {
                    throw new TclRuntimeError("FileCmd.cmdProc: bad option " + opt + " index to validOptions");
                }
            }
            ++firstSource;
        }
        if (firstSource >= argv.length - 1) {
            throw new TclNumArgsException(interp, firstSource, argv, "?options? source ?source ...? target");
        }
        int target = argv.length - 1;
        String targetName = argv[target].toString();
        File targetObj = FileUtil.getNewFileObj(interp, targetName);
        if (targetObj.isDirectory()) {
            int source = firstSource;
            while (source < target) {
                String sourceName = argv[source].toString();
                if (targetName.length() == 0) {
                    FileCmd.copyRenameOneFile(interp, sourceName, targetName, copyFlag, force);
                } else {
                    String tailName = FileCmd.getTail(interp, sourceName);
                    TclObject[] joinArrayObj = new TclObject[]{TclString.newInstance((String)targetName), TclString.newInstance((String)tailName)};
                    String fullTargetName = FileUtil.joinPath(interp, joinArrayObj, 0, 2);
                    FileCmd.copyRenameOneFile(interp, sourceName, fullTargetName, copyFlag, force);
                }
                ++source;
            }
        } else {
            if (firstSource + 1 != target) {
                String action = copyFlag ? "copying" : "renaming";
                throw new TclPosixException(interp, 20, "error " + action + ": target \"" + argv[target].toString() + "\" is not a directory");
            }
            String sourceName = argv[firstSource].toString();
            FileCmd.copyRenameOneFile(interp, sourceName, targetName, copyFlag, force);
        }
    }

    private static void copyRenameOneFile(Interp interp, String sourceName, String targetName, boolean copyFlag, boolean force) throws TclException {
        if (force && sourceName.equals(targetName)) {
            return;
        }
        String action = copyFlag ? "copying" : "renaming";
        File sourceFileObj = FileUtil.getNewFileObj(interp, sourceName);
        if (!sourceFileObj.exists() || sourceName.length() == 0) {
            throw new TclPosixException(interp, 2, true, "error " + action + " \"" + sourceName + "\"");
        }
        if (targetName.length() == 0) {
            throw new TclPosixException(interp, 2, true, "error " + action + " \"" + sourceName + "\" to \"" + targetName + "\"");
        }
        File targetFileObj = FileUtil.getNewFileObj(interp, targetName);
        if (targetFileObj.exists() && !force) {
            throw new TclPosixException(interp, 17, true, "error " + action + " \"" + sourceName + "\" to \"" + targetName + "\"");
        }
        if (sourceFileObj.isDirectory() && !targetFileObj.isDirectory()) {
            throw new TclPosixException(interp, 21, "can't overwrite file \"" + targetName + "\" with directory \"" + sourceName + "\"");
        }
        if (targetFileObj.isDirectory() && !sourceFileObj.isDirectory()) {
            throw new TclPosixException(interp, 21, "can't overwrite directory \"" + targetName + "\" with file \"" + sourceName + "\"");
        }
        if (!copyFlag) {
            if (!sourceFileObj.renameTo(targetFileObj)) {
                throw new TclPosixException(interp, 13, true, "error renaming \"" + sourceName + "\" to \"" + targetName + "\":  best guess at reason");
            }
        } else {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(sourceFileObj));
                BufferedWriter writer = new BufferedWriter(new FileWriter(targetFileObj));
                char[] cbuf = new char[256];
                int currentIndex = 0;
                int numChars = reader.read(cbuf, 0, 256);
                while (numChars != -1) {
                    writer.write(cbuf, currentIndex, numChars);
                    numChars = reader.read(cbuf, currentIndex += 256, 256);
                }
                reader.close();
                writer.close();
            }
            catch (Exception e) {
                throw new TclException(interp, "error copying: " + e.getMessage());
            }
        }
    }

    FileCmd() {
    }
}

