/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SplitCmd
implements Command {
    private static char[] defSplitChars = new char[]{' ', '\n', '\t', '\r'};

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        TclObject tclObject;
        char[] cArray = null;
        if (tclObjectArray.length == 2) {
            cArray = defSplitChars;
        } else if (tclObjectArray.length == 3) {
            tclObject = tclObjectArray[2];
            if (tclObject.stringRep == null) {
                tclObject.stringRep = tclObject.internalRep.toString();
            }
            cArray = tclObject.stringRep.toCharArray();
        } else {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "string ?splitChars?");
        }
        tclObject = tclObjectArray[1];
        if (tclObject.stringRep == null) {
            tclObject.stringRep = tclObject.internalRep.toString();
        }
        String string = tclObject.stringRep;
        int n = string.length();
        int n2 = cArray.length;
        if (n2 == 0) {
            TclObject tclObject2 = TclList.newInstance();
            if (tclObject2.internalRep == null) {
                throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
            }
            ++tclObject2.refCount;
            try {
                int n3 = 0;
                while (n3 < n) {
                    TclList.append(interp, tclObject2, TclString.newInstance(string.charAt(n3)));
                    ++n3;
                }
                interp.setResult(tclObject2);
                return;
            }
            finally {
                Object var9_13 = null;
                tclObject2.release();
            }
        }
        TclObject tclObject3 = TclList.newInstance();
        int n4 = 0;
        if (tclObject3.internalRep == null) {
            throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
        }
        ++tclObject3.refCount;
        try {
            int n5 = 0;
            while (n5 < n) {
                char c = string.charAt(n5);
                int n6 = 0;
                while (n6 < n2) {
                    if (c == cArray[n6]) {
                        TclList.append(interp, tclObject3, TclString.newInstance(string.substring(n4, n5)));
                        n4 = n5 + 1;
                        break;
                    }
                    ++n6;
                }
                ++n5;
            }
            if (n5 != 0) {
                TclList.append(interp, tclObject3, TclString.newInstance(string.substring(n4)));
            }
            interp.setResult(tclObject3);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            tclObject3.release();
            throw throwable;
        }
        Object var10_11 = null;
        tclObject3.release();
    }

    SplitCmd() {
    }
}

