      PROGRAM RICARDO12A
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON CLN(1315,5),CL(1315,5),X(1315),CELUTE(5,2000),V(2000),
     +GZERO(5)
      DIMENSION VEL(5),AXDIS(5),XI(5)
      REAL*8  LAMBDA(5),t1,t2,tsecnd

C RECORD START TIME
C     CALL mttimes
      t1=tsecnd()

      NV=40000
C     NV=400
      IOUT=40000
      N=1315
      NP=N-1
      NSEG = 46
      KELUTE=2000
      IELUTE=20
      DX=0.02
      XI(1)=0.8
      XI(2)=0.54
      XI(3)=0.54
      XI(4)=0.54
      XI(5)=0.54
      RATIO = XI(2) / XI(1)
      DV=XI(1)*DX/DBLE(IELUTE)
      AXDIS(1)=2.0E-02
      AXDIS(2)=6.0E-02
      AXDIS(3)=6.0E-02
      AXDIS(4)=6.0E-02
      AXDIS(5)=6.0E-02
      DO 1 M = 1,5
      VEL(M)=(1.0/XI(M))-(1.0/XI(1))
      AXDIS(M)=AXDIS(M)-0.5*VEL(M)*DX
      VEL(M)=DV*VEL(M)/DX
      LAMBDA(M)=DV*AXDIS(M)/(DX**2)
   1  CONTINUE
      VSEG=XI(1)*DX
      F = 20.6 / 3600.0
      EK0 = 1.1E05
      RDML = 0.5
      RAML = 2.0*EK0*RDML
      EKISOM = 20.0
      EKAPP = 0.5*EK0/(1.0 + EKISOM)
      RDML2 = 1.0
      RAML2 = EKAPP*RDML2
      RRISOM = 1.0E-03
      RFISOM = EKISOM*RRISOM
      COF1 = -RAML * DV / F
      COF2 = RDML * DV / F
      COF3 = RAML2 * DV / F
      COF4 = -RDML2 * DV / F
      COF5 = RFISOM * DV / F
      COF6 = -RRISOM * DV / F
      GZERO(1)=0.4038637706E-05
      GZERO(2)=0.7454342552E-05
      GZERO(3)=0.6623185565E-05
      GZERO(4)=0.0070055980E-05
      GZERO(5)=0.1401119600E-05
      L=1
      LN=2
      VOL=0.0
      CALL FILLUP(N,DX,L,LN,KELUTE,VSEG,NSEG)
C     CALL OUT(L,N,VOL,KELUTE,VSEG,F)

      DO 2 I = 1,NV

      DO 3 M = 1,5
      CLN(2,M)=CL(2,M)+LAMBDA(M)*(CL(3,M)-CL(2,M))
     X-VEL(M)*CL(2,M)
    3 CONTINUE

      DO 4 M=1,5
      DO 6 J=3,NP
      CLN(J,M)=CL(J,M)+LAMBDA(M)*(CL(J+1,M)-CL(J,M)
     X-CL(J,M)+CL(J-1,M))-VEL(M)*(CL(J,M)-CL(J-1,M))
  6   CONTINUE
      CLN(N,M)=CL(N,M)+LAMBDA(M)*(CL(N-1,M)-CL(N,M))
  4   CONTINUE

      CALL RUNKUT (COF1,COF2,COF3,COF4,COF5,COF6,RATIO,LN,N)

      IF ((I/IELUTE)*IELUTE.EQ.I) CALL RENUM(NP,LN,N,I,IELUTE,VOL,VSEG)

C     IF ((I/IOUT)*IOUT.EQ.I) CALL OUT(LN,N,VOL,KELUTE,VSEG,F)

C     LSAV=L
C     L=LN
C     LN=LSAV
  2   CONTINUE

C DUMP THE SYSTEM AFTER COMPUTATION COMPLETES L is LN
      CALL OUT(L,N,VOL,KELUTE,VSEG,F)
      t2=tsecnd()
      print *, t2-t1
      STOP
      END

      SUBROUTINE FILLUP(N,DX,L,LN,KELUTE,VSEG,NSEG)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON CLN(1315,5),CL(1315,5),X(1315),CELUTE(5,2000),V(2000),
     +GZERO(5)
      X(1)=0.0
      DO 1 J = 2,N
      X(J)=DBLE(J-1)*DX
  1   CONTINUE
      DO 2 M = 1,5
      CL(1,M)=0.0
      CLN(1,M)=0.0
      DO 3 J = 2,NSEG
      CL(J,M)=GZERO(M)
      CLN(J,M)=GZERO(M)
  3   CONTINUE
      DO 4 J = 1,KELUTE
      CELUTE(M,J)=0.0
  4   CONTINUE
  2   CONTINUE
      DO 5 J = 1,KELUTE
      V(J)=DBLE(J)*VSEG
  5   CONTINUE
      RETURN
      END

      SUBROUTINE RENUM(NP,LN,N,I,IELUTE,VOL,VSEG)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON CLN(1315,5),CL(1315,5),X(1315),CELUTE(5,2000),V(2000),
     +GZERO(5)
      K=I/IELUTE
      VOL=DBLE(K)*VSEG
      NPP = NP - 1
      MN = N + 1

      DO 1 M = 1,5
      CELUTE(M,K)=CL(N,M)

      DO 2 J = 1,NPP
      JM = MN-J
      CL(JM,M)=CL(JM-1,M)
  2   CONTINUE

      CL(2,M)=0.0
  1   CONTINUE
      RETURN
      END

      SUBROUTINE RUNKUT (COF1,COF2,COF3,COF4,COF5,COF6,RATIO,LN,N)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON CLN(1315,5),CL(1315,5),X(1315),CELUTE(5,2000),V(2000),
     +GZERO(5)
      DO 1 J = 2,N
      CMI = CLN(J,2)
      CLI = CLN(J,1)
      CMLI = CLN(J,3)
      CML2I = CLN(J,4)
      CML2ISOI = CLN(J,5)
      RKK1 = COF1*CMI*CLI + COF2*CMLI
      RKL1 = -(RKK1 + COF3*CMLI*CLI + COF4*CML2I)
      RKP1 = RATIO*(RKK1 + RKK1 + RKL1)
      RKM1 = COF5*CML2I + COF6*CML2ISOI
      RKN1 = -(RKK1 + RKL1 + RKM1)
      U = CLI + 0.5*RKP1
      W = CML2I + 0.5*RKN1
      XX = CMLI + 0.5*RKL1
      RKK2 = COF1*(CMI + 0.5*RKK1)*U + COF2*XX
      RKL2 = -(RKK2 + COF3*XX*U + COF4*W)
      RKP2 = RATIO*(RKK2 + RKK2 + RKL2)
      RKM2 = COF5*W + COF6*(CML2ISOI + 0.5*RKM1)
      RKN2 = -(RKK2 + RKL2 + RKM2)
      VV = CLI + 0.5*RKP2
      Y = CMLI + 0.5*RKL2
      Z = CML2I + 0.5*RKN2
      RKK3 = COF1*(CMI + 0.5*RKK2)*VV + COF2*Y
      RKL3 = -(RKK3 + COF3*Y*VV + COF4*Z)
      RKP3 = RATIO*(RKK3 + RKK3 + RKL3)
      RKM3 = COF5*Z +COF6*(CML2ISOI + 0.5*RKM2)
      RKN3 = -(RKK3 + RKL3 + RKM3)
      R = CLI + RKP3
      S = CMLI + RKL3
      T = CML2I + RKN3
      RKK4 = COF1*(CMI + RKK3)*R + COF2*S
      RKL4 = -(RKK4 + COF3*S*R + COF4*T)
      RKP4 = RATIO*(RKK4 + RKK4 + RKL4)
      RKM4 = COF5*T + COF6*(CML2ISOI + RKM3)
      RKN4 = -(RKK4 + RKL4 + RKM4)
      DELK = (RKK1 + RKK2 + RKK2 + RKK3 + RKK3 + RKK4)/6.0
      DELL = (RKL1 + RKL2 + RKL2 + RKL3 + RKL3 + RKL4)/6.0
      DELM = (RKM1 + RKM2 + RKM2 + RKM3 + RKM3 + RKM4)/6.0
      CL(J,2) = CMI + DELK
      CL(J,3) = CMLI + DELL
      CL(J,1) = CLI + RATIO*(DELK + DELK + DELL)
      CL(J,5) = CML2ISOI + DELM
      CL(J,4) = CML2I - (DELK + DELL + DELM)
    1 CONTINUE
      RETURN
      END

      SUBROUTINE OUT(L,N,VOL,KELUTE,VSEG,F)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON CLN(1315,5),CL(1315,5),X(1315),CELUTE(5,2000),V(2000),
     +GZERO(5)
      DIMENSION CTL(2000),CTM(2000)

      DO 2 J = 1,KELUTE
      CTL(J) = CELUTE(1,J) + CELUTE(3,J) + CELUTE(4,J) +
     XCELUTE(4,J) + CELUTE(5,J) + CELUTE(5,J)
      CTM(J) = CELUTE(2,J) + CELUTE(3,J) + CELUTE(4,J) +
     XCELUTE(5,J)
    2 CONTINUE

      TOTM = 0.0
      TOTML = 0.0
      TOTML2 = 0.0
      TOTML2I = 0.0
      DO 4 J = 1,KELUTE
      TOTM = TOTM + CELUTE(2,J)
      TOTML = TOTML + CELUTE(3,J)
      TOTML2 = TOTML2 + CELUTE(4,J)
      TOTML2I = TOTML2I + CELUTE(5,J)
    4 CONTINUE

      TOT = TOTM + TOTML + TOTML2 + TOTML2I

      IF (TOT .EQ. 0.0) THEN
C     CALL mttimes
      GO TO 6
      ENDIF

      PERML = 100.0 * (TOTML + TOTML2 + TOTML2I) / TOT

      TOTMA = 1.554870369E-05 * 0.486

      TOT1=0.0
      TOT2=0.0
      STOR=CTL(915)
      JSTOR=915
      DO 7 J=1,KELUTE
      TOT1=TOT1 + CTL(J)
      IF (J.LT.915.OR.J.GT.1190) GO TO 7
      IF (STOR.LT.CTL(J)) GO TO 7
      STOR=CTL(J)
      JSTOR=J
    7 CONTINUE
      DO 8 J=1,JSTOR
      TOT2=TOT2 + CTL(J)
    8 CONTINUE
      PERCENT=100.0*TOT2/TOT1
      HL=-LOG(2.0)*DBLE(JSTOR)*0.016/(F*LOG(PERCENT/18.02233))

C RECORD FINAL TIME
C     CALL mttimes
      GO TO 6

      WRITE (0,100) VOL
 100  FORMAT (' ',' ',2X,'VOLUME OF ELUATE =',E12.6,2X,'ML')
C     WRITE (0,200)
C 200 FORMAT(' ',' ',9X,'POSITION',9X,'CONCL',10X,'CONCM',8X,
C    X'CONCML',9X,'CONCML2',9X,'CONCML2*')
C     DO 1 J=1,60
C     WRITE (0,300) X(J),C(1,J,L),C(2,J,L),C(3,J,L),C(4,J,L),C(5,J,L)
C   1 CONTINUE
  300 FORMAT(' ',2X,6E15.6)
C     WRITE (0,400)
 400  FORMAT (' ',' ',130('_'))
C     WRITE (0,500)
 500  FORMAT (' ',' ',9X,'VOLUME',11X,'CONCL',9X,'CONCM',10X,'CONCML',
     X8X,'CONCML2',8X,'CONCML2*',7X,'TOTAL M',8X,'TOTAL L')
C     DO 3 J = 1,KELUTE,4
C     WRITE (0,600) V(J),CELUTE(1,J),CELUTE(2,J),CELUTE(3,J)
C    X,CELUTE(4,J),CELUTE(5,J),CTM(J),CTL(J)

C     WRITE(0,612)

C     DO 3 J = 1,KELUTE,4
C     WRITE (0,600) CTM(J), CTM(J+1), CTM(J+2), CTM(J+3)
C   3 CONTINUE

C     WRITE (0,610)

C     DO 40 J = 1,KELUTE,4
C     WRITE (0,600) CTL(J), CTL(J+1), CTL(J+2), CTL(J+3)
C  40 CONTINUE

  600 FORMAT (' ',4(2X,1E15.6))
  610 FORMAT (' ',2X,' CTL ')
  612 FORMAT (' ',2X,' CTM ')

C     WRITE (0,400)

      WRITE (0,700) TOTM,TOTML
      WRITE (0,701) TOTML2,TOTML2I
      WRITE (0,750) TOT
      WRITE (0,800) PERML
  700 FORMAT (' ',' ',2X,'TOTAL M =',E12.6,2X,'TOTAL ML =',E12.6,
     X2X)
  701 FORMAT (' ',' TOTAL ML2 =',E12.6,2X,'TOTAL  ML2I =',E12.6)

  750 FORMAT (' ',' ',2X,'TOTAL (M + ML + ML2 + ML2*) =',E12.6)
  800 FORMAT (' ',' ',2X,'PERCENTAGE (ML + ML2 + ML2*) = ',F6.2)
      WRITE (0,900) TOTMA
  900 FORMAT (' ',' ',2X,
     X'TOTAL (M + ML + ML2 + ML2*) APPLIED TO COLUMN = ',E12.6)
C     WRITE (0,400)

      WRITE (0,910) JSTOR,STOR
  910 FORMAT (' ',' ',2X,'MINIMUM J =',I4,2X,
     X'MINIMUM LIG CONC =',E12.6)
      WRITE (0,920) PERCENT,HL
  920 FORMAT (' ',' ','PERCENT FAST PEAK =',F9.5
     X,2X,'APPARENT HALF-LIFE =',F11.4)
C     WRITE (0,400)
    6 RETURN
      END
