
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

 /* timings: */
 /* -i: 18.5u */
 /* -s: 14.2u   */
 /* -n: 15.3u */
 /* -f: 14.4u */

#include <stream.h>

typedef int Cell;
const int SIZE = 1000000;
Cell array[SIZE];

struct upstack {
  Cell* sp;
  Cell* sp0;
  void init(Cell* p) {sp0 = sp = p;}
  void init(Cell* bottom, Cell* top) {sp0 = bottom; sp = top;}
  Cell* bottom() {return sp0;}
  void push(Cell val) {*sp++ = val;}
  Cell pop() {return *--sp;}
  int nonempty() {return (sp > sp0);}
};

upstack S;

main(int, char** argv)
{
  S.init(array);
  upstack Local;
  Local.init(array);
  upstack* SP = &S;
  Cell* p = array;
  Cell var;
  for (int j = 0; j < 5; j++) {
    switch (argv[1][1]) {
    case 'n':
      for (int i = 0; i < SIZE; i++) {
	S.push(i);
	var = S.pop();
      }
      break;
    case 'f':
      for (i = 0; i < SIZE; i++) {
	*p++ = i;
	var = *--p;
      }
      break;
    case 's':
      for (i = 0; i < SIZE; i++) {
	Local.push(i);
	var = Local.pop();
      }
      break;
    case 'i':
      for (i = 0; i < SIZE; i++) {
	SP->push(i);
	var = SP->pop();
      }
      break;
    case 'h':
    default:
      cout << "-[isnf] indirect, slow, normal, fast\n";
    }
  }
}
