
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

#include <stream.h>
#include <ctype.h>
#include "hash_table.h"
#include "string_table.h"
#include "scan.h"

void Scan::place_pointers()
{
  static const char quote_char = '\'';
  register char* head = input_buffer;
  char* q[4];
  int quotes;
  for (int i = 0; i < 4; i++) {
    quotes = 0;
    while (isspace(*head))
      head++;
    if (*head == ',')
      head++;
    if (*head == quote_char) {
      quotes = 1;
      head++;
    }
    p[i] = head;
    if (quotes == 1) {
      while (*head != quote_char && *head != '\0') 
	head++;
      q[i] = head;
      if (*head == quote_char)
	head++;
    } else {
      while (*head != ',' && !isspace(*head) && *head != '\0')
	head++;
      q[i] = head;
    }
  }
  for (i = 0; i < 4; i++) 
    *q[i] = '\0';
}

void Scan::next_line()
{
  char nl;
  for (;;) {
    cin.get(input_buffer, buffer_size,'\n');
    cin.get(nl);
    if (cin.rdstate() != _good) {
      status = SCAN_EOF;
      return;
    }
    place_pointers();
    if (*p[0] != '\0')
      break;
  }
  if (*p[0] == '_') {
    status = SCAN_DEF_LABEL;
    return;
  }
  intern_p0 = intern(p[0]);
  if (intern_p0 == end || *p[0] == '[') { /* last message of compiler "[... */
    status = SCAN_EOF;
    return;
  }
  if (intern_p0 == procedure) {
    status = SCAN_DEF_PROC;
    return;
  }
  status = SCAN_INSTR;
}

void Scan::print_state()
{
  cout << " status = " << status << "\t";
  for (int i = 0; i < 4; i++)
    cout << "\"" << p[i] << "\" ";
  cout << "\n";
}

#ifdef DEBUG_SCAN
void out_of_store()
{
  cerr << "operator new failed: out of store\n";
  exit(1);
}
typedef void (*PF)();
extern PF set_new_handler(PF);

main() {
  Scan S;
  set_new_handler(&out_of_store);
  cout << "Try out a scanner \n";
  while (S.status != SCAN_EOF) {
    S.next_line();
    S.print_state();
  }
  S.print();
}
#endif
