
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

struct HashTableEntry {
  int key;
  int value;
  HashTableEntry* next;
  void print() {printf("(%d,%d)\n", key, value);}
};

enum {HASH_HIT, HASH_MISS};

class HashTable {
  HashTableEntry* next_entry;
  HashTableEntry* next_entry0;
  HashTableEntry** next_cell;
  int next_index;
  void reenter_old_data(int, HashTableEntry**);
  HashTableEntry** get_cell(int);
 public:
  char* alloc_area;
  void allocate();
  void rehash();
  HashTableEntry** table;
  int size;
  int status;
  int get_status() {return status;}
  HashTable(int size =1001);
  HashTableEntry* new_cell() {
    return (next_entry >= next_entry0) ? 0 : next_entry++;
  }
  void bind(int, int);
  int get(int);
  void clear();
  void reset();			/* should be called before any next */
  HashTableEntry* next();
  virtual void print();
};
