
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* the first thousand prime numbers. List processing and arithmetic */

main :-
	primes(1000, X),	
	write(X),
	nl.

primes(Limit, Primes) :-
	integers(2, Limit, Ints),
	sift(Ints, Primes).

integers(Low, High, [Low|Rest]) :-
	Low =< High,
	!,	
	M is Low + 1,
	integers(M, High, Rest).
integers(_,_,[]).

sift([],[]).
sift([Int|Ints], [Int|Primes]) :-
	remove_multiples(Int, Ints, IntsLeft),
	sift(IntsLeft, Primes).

remove_multiples(P, [], []).
remove_multiples(P, [Int|Ints], IntsLeft) :-
	0 is Int mod P,
	!,
	remove_multiples(P, Ints, IntsLeft).
remove_multiples(P, [Int|Ints], [Int|IntsLeft]) :-
	remove_multiples(P, Ints, IntsLeft).

