
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% eliminate redundant assignments
% We can remove a put_value Yj,Xi when:
%   1) it's before the first call, and
%   2) Yj was initialized by a get_variable, and
%   3) between the get_variable and the put_value, there's no get, put, or
%	unify instruction which references Xi.  (This is probably overkill,
%	but it is correct.)
% The purpose of this optimization is to fix code for clauses like:
%	a(X) :- b(X), x(X).
% which generates:
%	get_variable Y1,X1
%	put_value Y1,X1		< redundant instruction >
%	call b/1
%		-- Wayne (1/28)

assn_elim(Code, ACode) :-
	assn_elim(Code, ACode,live(no,no,no,no,no,no,no)).

assn_elim([I|Rest], [I|Rest],_) :- 
	I = call(_,_), !.
assn_elim([], [], _) :- !.
assn_elim([get(variable,Y,R)|Rest], 
	  [get(variable,Y,R)|NewRest],
	  Live) :-
	nonvar(Y), 
	Y=y(J),  
	R=x(I), nonvar(I), I\==8, !,
	make_live(Live,I,J,NewLive),
	assn_elim(Rest,NewRest,NewLive).
assn_elim([put(value,Y,R)|Rest],
	  NewRest,
	  Live) :-
	nonvar(Y), Y=y(J), R=x(I), nonvar(I), is_live(Live,I,J), !,
	assn_elim(Rest,NewRest,Live).
assn_elim([I|Rest], [I|NewRest], Live) :-
	(I=put(A,X,Y); I=get(A,X,Y); I=unify(A,X)),
	(nonvar(X), X=x(K), nonvar(K) ->
		make_dead(Live,K,NewLive);
		NewLive = Live),
	(nonvar(Y), Y=x(J), nonvar(J) ->
		make_dead(NewLive,J,NewLive2);
		NewLive2=NewLive), !,
	assn_elim(Rest,NewRest,NewLive2).
assn_elim([I|Rest], [I|NewRest], Live) :-
	assn_elim(Rest,NewRest,Live).

% Live structure has exactly seven elements.
make_live(live(A1,A2,A3,A4,A5,A6,A7),1,J,
	  live(J,A2,A3,A4,A5,A6,A7)).

make_live(live(A1,A2,A3,A4,A5,A6,A7),2,J,
	  live(A1,J,A3,A4,A5,A6,A7)).

make_live(live(A1,A2,A3,A4,A5,A6,A7),3,J,
	  live(A1,A2,J,A4,A5,A6,A7)).

make_live(live(A1,A2,A3,A4,A5,A6,A7),4,J,
	  live(A1,A2,A3,J,A5,A6,A7)).

make_live(live(A1,A2,A3,A4,A5,A6,A7),5,J,
	  live(A1,A2,A3,A4,J,A6,A7)).

make_live(live(A1,A2,A3,A4,A5,A6,A7),6,J,
	  live(A1,A2,A3,A4,A5,J,A7)).

make_live(live(A1,A2,A3,A4,A5,A6,A7),7,J,
	  live(A1,A2,A3,A4,A5,A6,J)).

make_dead(live(A1,A2,A3,A4,A5,A6,A7),1,
	  live(no,A2,A3,A4,A5,A6,A7)).

make_dead(live(A1,A2,A3,A4,A5,A6,A7),2,
	  live(A1,no,A3,A4,A5,A6,A7)).

make_dead(live(A1,A2,A3,A4,A5,A6,A7),3,
	  live(A1,A2,no,A4,A5,A6,A7)).

make_dead(live(A1,A2,A3,A4,A5,A6,A7),4,
	  live(A1,A2,A3,no,A5,A6,A7)).

make_dead(live(A1,A2,A3,A4,A5,A6,A7),5,
	  live(A1,A2,A3,A4,no,A6,A7)).

make_dead(live(A1,A2,A3,A4,A5,A6,A7),6,
	  live(A1,A2,A3,A4,A5,no,A7)).

make_dead(live(A1,A2,A3,A4,A5,A6,A7),7,
	  live(A1,A2,A3,A4,A5,A6,no)).

is_live(Live,I,J) :- arg(I,Live,J).
