signature GeneralTypes =

(* GENERAL TYPES AND EXCEPTIONS

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        21 Feb 1989

   Maintenance: Author


   DESCRIPTION

   The types and exceptions defined in General and made available globally.
*)
sig
  datatype 'a Option = None | Some of 'a
    sharing type Option = General.Option

  type Nat
    sharing type Nat = int

  datatype ('a, 'b) Result = OK of 'a | Fail of 'b
    sharing type Result = General.Result

  (* The next two exceptions are used by the redefinition of the
     pervasive arithmetic operations. *)
  exception Overflow
  and OldDiv
end
