(*$System : GeneralTypes *)

loadSig "System";

structure System: System =

(* SYSTEM FUNCTIONS

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk

   Date:        14 Nov 1989

   Maintenance: Author

*)

struct

  val version = 0.1


(* ML SYSTEM *)

  fun quit () = raise General.NotImplemented "quit";

  fun collect () = ();

  fun eq x y = false;


(* ML SOURCE FILES *)

  fun make _ = raise General.NotImplemented "make"

  fun use _ = raise General.NotImplemented "use"


(* INTERFACE TO OPERATING SYSTEM *)

  exception NoFile of string * string

  exception Permission of string * string

  fun cd _ = raise General.NotImplemented "cd"

  fun pwd _ = raise General.NotImplemented "pwd"

  fun dir _ = raise General.NotImplemented "dir"

  fun delete _ = raise General.NotImplemented "delete"

  fun system _ = raise General.NotImplemented "system"

  fun getenv _ = raise General.NotImplemented "getenv"

end
