
structure StringObject': Object =

(* ASCII STRINGS

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        12 Feb 1990

   Maintenance: Author

   DESCRIPTION

   Object definition for the built-in type "string".

*)

struct

(* TYPES *)

  type T = string


(* CONVERTORS *)

  open StringParse


(* LOCAL *)

  fun lower s = 
        if StringType.isUpper s
        then chr (ord s + ord "a" - ord "A") ^
		implode (List'.extract 1 (size s - 1) (explode s))
        else s
        handle StringType.Empty _ => raise StringType.Empty "lower"


(* OBSERVERS *)

  val fixedWidth = false

  (* Relational operators use Ascii ordering. *)
  local
    fun ltNoCase x y = ord (lower x) < ord (lower y)
    fun gtNoCase x y = ord (lower x) > ord (lower y)
    fun eqNoCase x y = (ord (lower x) = ord (lower y))
    fun neNoCase x y = ord (lower x) <> ord (lower y)
	  
    fun compare p q listFn x y = 
	if p x y then true
	else if q x y then false
	else listFn (compare p q listFn) (explode x) (explode y)
  in
    fun lt _  "" = false
    |   lt "" _  = true
    |   lt x  y  = compare ltNoCase gtNoCase List'.lt x y

    fun le "" _  = true
    |   le _  "" = false
    |   le x  y  = compare ltNoCase gtNoCase List'.le x y

    fun gt "" _  = false
    |   gt _  "" = true
    |   gt x  y  = compare gtNoCase ltNoCase List'.gt x y

    fun ge "" _  = true
    |   ge _  "" = false
    |   ge x  y  = compare gtNoCase ltNoCase List'.ge x y

    fun eq "" "" = true
    |   eq "" _  = false
    |   eq _  "" = false
    |   eq x  y  = compare eqNoCase neNoCase List'.eq x y

    fun ne "" "" = false
    |   ne "" _  = true
    |   ne _  "" = true
    |   ne x  y  = compare eqNoCase neNoCase List'.eq x y
  end

end
