
structure StringObject: Object =

(* ASCII STRINGS

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        12 Feb 1990

   Maintenance: Author

   DESCRIPTION

   Object definition for the built-in type "string".

*)

struct

(* TYPES *)

  type T = string


(* CONVERTORS *)

  open StringParse


(* OBSERVERS *)

  val fixedWidth = false

  fun lt x y = OldString.< (x, y)

  fun le x y = OldString.<= (x, y)

  fun gt x y = OldString.> (x, y)

  fun ge x y = OldString.>= (x, y)

  fun eq x y = (x = y)

  fun ne x y = (x <> y)
end
