;;; This file contains extra functions for manipulating files, etc.
;;; It is only for "bvz" and "koz", and need not be used by general
;;; Lapidary users...

(defun myloader(&optional desired-user)
  (let* ((true-user (cdr (assoc :USER ext::*environment-list*)))
	 (user (cond (desired-user)
		     ((string= true-user "kosbie") "koz")
		     (t true-user)))
	 (dir (concatenate 'string "/afs/cs/user/koz/garnet/editor/" user))
	 (dirfiles (mapcar #'namestring (directory dir)))
	 (*load-verbose* t)
	 fasl-list fbase fext dotposn shortname slashposn
	)
    (format t "Loading files for ~A from ~A~%" true-user dir)
    (dolist (file dirfiles)
	(setq shortname (if (setq slashposn (position #\/ file :from-end t))
				(subseq file slashposn)
				file))
	(setq dotposn (position #\. shortname :from-end t))
	(setq fbase (subseq shortname 0 dotposn))
	(setq fext  (subseq shortname dotposn))
	(cond ((string= fext ".fasl")
		(load file)
		(push fbase fasl-list))
	      ((and (string= fext ".lisp")
		    (not (member fbase fasl-list :test #'string=)))
		(load file))
	))))
