-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
main: using (main,predefined,common,window,terminalio,load,CLoad)
  process (Q: mainQ)
  declare
    args: main;
    poly: common!polymorph;
    window: windowFn;
    hw: terminalFunctions;
    close: signalPort;
    empty: empty;
    data: charstring;
    pathLoad: load_func;
    CLoad: CLoadFn;
  begin
    block begin
      receive args from Q;
    on (disconnected)
      exit done;
    end block;
    unwrap pathLoad from args.rm.get("pathLoad","") {init};
    unwrap CLoad from args.rm.get("Cloader", "") {init};
    window <- procedure of pathLoad("window");
    call args.terminal.putLine("Calling window");
    close <- window(CLoad,"Hello world.","No options.",hw);
    call args.terminal.putLine("Done opening window");
    data <- "Nothing yet.";
    while ('true') repeat
	if (data="done read") then 
	    send empty to close;
	  end if;
	call args.terminal.putLine("Reading...");
	data <- hw.getString();
	print data;
	if (data="done write") then
	    send empty to close;
	  end if;
	call hw.putLine(data);
      end while;
  on (getStringIntf.endOfInput)
    call args.terminal.putLine("End of input.");
    return args;
  on (getStringIntf.discarded,putStringIntf.discarded)
    call args.terminal.putLine("Discarded callmessage.");
    return args;
  on (disconnected)
    call args.terminal.putLine("Window is gone.");
    return args;
  on exit(done)
    
  end process
       
