-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: predupkey.p
-- Author: Rob Strom
-- SCCS Info: @(#)predupkey.p	1.2 3/13/90

predupkey : USING( tscheck, Predefined  ) PROCESS (PreDuplicateKeyInit : DeterminePreconditionInport )
-- If the given table is keyed, generate an exception branch for DuplicateKey
  DECLARE
    FP: DeterminePreconditionCall ;
    TType: TypeName; -- type of table object
  BEGIN
    RECEIVE FP FROM PreDuplicateKeyInit ;
    INSPECT Obj IN FP.Statement.Operands WHERE(POSITION OF Obj = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 0))
      BEGIN
        TType <- FP.Services.TypeOf(FP.Services, FP.Declarations, FP.Definitions, FP.Context, Obj);
	INSPECT Module IN FP.Definitions WHERE(Module.Id = TType.ModuleId)
	  BEGIN
	    INSPECT Definition IN Module.Type_Definitions WHERE(Definition.Id = TType.TypeId)
	      BEGIN
		-- 2, 3.
		REVEAL Definition.Specification.Table_info; 
		IF SIZE OF Definition.Specification.Table_info.keys > 0
		  THEN
		    CALL FP.Services.ExceptionBranch(FP.Services, FP.Declarations, FP.Definitions, FP.Context, (EVALUATE ExceptionHandler : HandlerName FROM
		      UNITE ExceptionHandler.Builtin FROM 'DuplicateKey';
		      END), FP.CurrentTS);
		  END IF;
              END INSPECT;
          END INSPECT;
      END INSPECT;
    RETURN FP;
  END PROCESS
