-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: involving.p
-- Author: Rob Strom
-- SCCS Info: @(#)involving.p	1.1 7/27/89
-- Inputs:
-- A variable name: FP.Object
-- A set of attributes of FP.Object and its descendants: FP.AttributeList
-- The current typestate: FP.CurrentTS
-- Output: The attributes which must be dropped in order that:  
--         (1) the only surviving attributes of FP.Object and its descendants are those on FP.AttributeList
--         (2) the resulting typestate is valid
-- Algorithm:
-- Select those attributes obeying the following properties
-- (1) Rootname of FP.Object matches rootname of an attribute parameter (redundant check to quickly eliminate attrs)
-- (2) Attribute not in FP.AttributeList
-- (3) Either
--        (a) Some parameter (not 2nd of a case) equals FP.Object or a descendant
--        or
--        (b) The attribute is a constraint or CHECKED or CHECKEDDEFINITIONS;
--            some parameter is a strict ancestor of FP.Object,
--            some attribute required by that constraint, CHECKED or CHECKEDDEFINITIONS
--            includes FP.Object or a descendant but does not appear on FP.AttributeList
Involving : USING( Predefined, tscheck  ) PROCESS ( InvolvingInit : InvolvingInport )
  DECLARE
    FP: InvolvingCall;
    SizeOfComponents: integer;
  BEGIN
    RECEIVE FP From InvolvingInit;
    SizeOfComponents <- SIZE OF FP.Object.Components; -- (manual code motion optimization)
    FP.Prerequisites <- EVERY OF Attribute IN FP.CurrentTS WHERE(EVALUATE Select: Boolean FROM
      -- 1
      IF EXISTS OF Parm IN Attribute.Objects WHERE(Parm.Root = FP.Object.Root)
	THEN
	  -- 2
	  IF EXISTS OF FP.AttributeList[Attribute]
	    THEN
	      Select <- 'false';
	    ELSE
	      -- 3a
	      Select <- EXISTS OF Parm IN Attribute.Objects WHERE(EVALUATE Subset: Boolean FROM
		Subset <- FP.Object.Root = Parm.Root AND SizeOfComponents <= SIZE OF Parm.Components;
		IF Subset
		  THEN
		    Subset <- FORALL OF Component in FP.Object.Components WHERE(Component = Parm.Components[POSITION OF Component]);
		  END IF;
		IF Subset AND POSITION OF Parm = 1
		  THEN
		    Subset <- CASE OF Attribute.Name <> 'case';
		  END IF;  
		END);
	      -- 3b
	      IF Select 
		THEN
		ELSE
		  IF (case of Attribute.Name = 'checked' OR case of Attribute.Name = 'checkeddefinitions')
		    THEN
		      BLOCK
			BEGIN
			  INSPECT Parm IN Attribute.Objects WHERE (EVALUATE Ancestor: Boolean FROM
			    Ancestor <- FP.Object.Root = Parm.Root AND SIZE OF Parm.Components < SizeOfComponents;
			    IF Ancestor
			      THEN
				Ancestor <- FORALL OF Component IN Parm.Components WHERE(Component = FP.Object.Components[POSITION OF Component]);
			      END IF;
			    END)
			    BEGIN
			      -- since programs and definitions modules have only one level of
			      -- descendants, FP.Object must be a direct descendant, so
			      -- just check for INIT(FP.Object) in the FP.AttributeList
			      -- (until constraints are there, this will usually be not found)
			      Select <- NOT EXISTS OF Attr IN FP.AttributeList WHERE(case of Attr.Name = 'initialized' AND Attr.Objects[0] = FP.Object);
			    END INSPECT;
			ON (NotFound) -- Select stays false
			END BLOCK;
		    ELSE -- not doing general constraints at this time
		    END IF;
		END IF;
	    END IF;
	ELSE
	  Select <- 'false';
	END IF;
      END);
    RETURN FP;
  END PROCESS
