-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)casetypeof.p	1.3 3/13/90 

-- The function CaseTypeOf is a type inference function called by Infer.
-- It returns the case type of its argument which must be a variant

casetypeof: using(type)

PROCESS(InferQ: InferRuleQueue)
DECLARE
  InferM: InferRuleMessage;

BEGIN
  RECEIVE InferM FROM InferQ;
  INSPECT definitions_module IN InferM.definitions 
    	WHERE(boolean#(definitions_module.id = InferM.argument.moduleid))
  BEGIN
    INSPECT type_def IN definitions_module.type_definitions
	  WHERE(boolean#(type_def.id = InferM.argument.typeid))
    BEGIN
      BLOCK BEGIN
	REVEAL type_def.specification.variant_info;
	InferM.result := type_def.specification.variant_info.case_type;
	RETURN InferM;
      ON (CaseError) -- type_def is not of varianttype
	RETURN InferM EXCEPTION wrongArgType;
      END BLOCK;
    END INSPECT;
  END INSPECT;
END process

