-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- specifies the graph structure which defines how objects are connected by
-- pipes.

plumbing: using (main, common, terminalIO) definitions
    
    procId: nominal;		-- id for process nodes
    pipeId: nominal;		-- id for pipe arcs
    

    procNode: record (
	id: procId,		-- id for this node
	proc: mainFn,		-- process to invoke
	argv: charstringList,	-- command line args
	terminal: terminalFunctions,-- "terminal" I/O
	inputs: namedPipeSet,	-- input pipes
	outputs: namedPipeSet	-- output pipes
      );
    

    pipeArc: record (
	id: pipeId,		-- id for this arc
	source: procId,		-- source process
	sink: procId		-- sink process
      );
    

    namedPipeSet: table of namedPipe { full } keys (name) (id);

    namedPipe: record (
	name: charstring,	-- its local name
	id: pipeId		-- id of arc
      );
    
    
    procSet: table of procNode { full } keys (id);
    pipeSet: table of pipeArc { full } keys (id);
    
  end definitions

