-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: cat.p
-- Author: Andy Lowry
-- SCCS Info: @(#)cat.p	1.4 1/11/92

-- Takes file names as command line arguments.  Reads each file and
-- then sends its contents out on stdout.  If "-" appears on the
-- command line, stdin is read and copied to stdout until endOfInput.

cat: using (main, stdio, common, unix, terminalIO)

process (Q: mainQ)
  
declare
  args: main;
  stdout: stdout;
  stdin: stdin;
  stdio: stdio;
begin
  receive args from Q;
  
  -- get file reading capabilities and set up read buffer
  unwrap stdio from args.rm.get("stdio", "") { init, init(fopen) };
  -- get output capabilities
  unwrap stdout from args.rm.get("stdout", "stdio")
      {init, init(putChar), init(putString), init(putLine)};
  
  -- process each file in turn, skipping interpreter name and our
  -- program name
  for arg in args.argv where (position of arg >= 2) inspect
    if arg = "-" then
      block begin
	unwrap stdin from args.rm.get("stdin", "stdio") 
	    {init, init(getString), init(getChar)};
	while 'true' repeat
	  call stdout.putLine(stdin.getString());
	end while;
      on (getStringIntf.endOfInput)
      end block;
    else
      block declare
	file: stream;
      begin
	file <- stdio.fopen(copy of arg, 'read');
	block begin
	  while 'true' repeat
	    call stdout.putString(file.fread(100));
	  end while;
	on (getBoundedStringIntf.endOfInput)
	  call file.fclose();
	end block;
      on (fopen.couldNotOpen)
	-- couldn't open this file
      end block;

    end if;
  end for;
  return args;
end process
