-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pprintshell.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)pprintshell.p	1.4 3/2/92"
-- receives process name & prints out fact that need to invoke pcom(name)
pprintshell: using(terminalio,make,getdep)
process(ActionInitQ: ActionInitq)

declare
  ActionInitArgs: ActionInitIntf;
  string: charstring;
  q: ActionQ;
  fn: ActionFunc;
  args: ActionIntf;
  putline: terminalio!putStringFunc;
  
begin
  receive ActionInitArgs from ActionInitQ;
  putline := ActionInitArgs.terminal.putline;  
  string <- "pcom(" | copy of ActionInitArgs.name;
  insert ')' into string;
  new q;
  connect fn to q;
  ActionInitArgs.action <- fn;
  return ActionInitArgs;

  -- wait for call
  receive args from q;
  call putline(string);   
  args.made <- 'true';  -- compilation success

  return args;
  
on (disconnected)
  -- target was not re-made
end process
