-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: startnet.p
-- Author: Andy Lowry
-- SCCS Info: @(#)startnet.p	1.1 3/11/91

-- This process takes a single integer argument, which should be
-- unique among all hermes interpreters currently running on any given
-- host.  It issues the "start network" C-Hermes function to establish
-- the possibility of networked communication with other hermes
-- interpreters.  The interpreter number argument defaults to 1 if it
-- is omitted

startNet: using (main, CLoad, distributed, string)
linking (atoi)

process (Q: MainQ)
  
declare
  args: Main;
  atoi: string2IntFn;
  startNet: startNetworkFn;
  CLoad: CLoadFn;
  interpNo: integer;
begin
  receive args from Q;
  atoi <- procedure of process atoi;
  
  unwrap CLoad from args.rm.get("CLoader", "") {init};
  unwrap startNet from CLoad("start network") {init};
  
  -- get interpreter number for this interpreter and start network support
  block begin
    interpNo <- atoi(args.argv[2]);
  on (notFound)
    interpNo <- 1;
  end block;

  call startNet(interpNo);

  return args;
end process
