/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: o_cntl.c */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)o_cntl.c	1.14 2/17/92";
#endif

/* /local/hermes/li/o_cntl.c, Tue Aug 30 09:39:16 1988, David F. Bacon */
/*  moved code to turn off waiting_owner fields of inports being selected */
/*  from the newly reveived select statement to the ip_enqueuer; otherwise, */
/*  waiting process could be revived more than once, trashing the ready list. */
/*  also, wasn't setting the selecting flag, which caused major lossage. */

#include "ops.h"
#include "storage.h"
#include "accessors.h"

#define Dst (DstObj->value)
#define Src (SrcObj->value)
#define Src1 (Src1Obj->value)
#define Src2 (Src2Obj->value)

NILOP(o_branch)
{
  args->nextop = args->qualifiers.integer;
				/* set next operation to the branch label. */
}


NILOP(o_branch_false)
{
  OPCHK(DstObj,boolean);
  if (not Dst.boolean)
    args->nextop = args->qualifiers.integer;
}


NILOP(o_branch_true)
{
  OPCHK(DstObj,boolean);
  if (Dst.boolean)
    args->nextop = args->qualifiers.integer;
}


/*ARGSUSED*/
NILOP(o_noop)
{
}


NILOP(o_block)
{
    predef_exception retcode;
    predef_exception che_block();

    if ((retcode = che_block(args->qualifiers, args->sched)) isnt Normal)
      raise_builtin(retcode);
}

/* che_block is called directly by generated C-code */
predef_exception
che_block(qualifier, sched)
valcell qualifier;
schedblock *sched;
{
    context_info *context;
    handlr_stack *hstack;

    if ((hstack = new(handlr_stack)) is nil)
	return(Depletion);

    context = sched->ready->ep.h->info.context;
				/* get current context. */
    hstack->handler = TRUE;	/* this is a handler, not a find frame. */
    hstack->frame.handler_set = qualifier;
				/* set frame pointer. */
    cdr(hstack) = context->estack;
    context->estack = hstack;	/* push the new exception handler frame. */
    return(Normal);
}


NILOP(o_endblock)
{
    predef_exception retcode;
    void che_endblock();

    che_endblock(args->sched);
}

/* che_endblock is called directly by generated C-code */
void
che_endblock(sched)
schedblock *sched;
{
    context_info *context;
    handlr_stack *deadtop;

    context = sched->ready->ep.h->info.context;

    deadtop = context->estack;
    context->estack = cdr(deadtop);
    { dispose(deadtop,handlr_stack); }
}


NILOP(o_exit)
{
    void raise_exit();

    raise_exit(args->qualifiers, args);
}


NILOP(o_raise)
{
    raise_builtin((predef_exception) args->qualifiers.ord_enum);
}


NILOP(o_select)
{
    predef_exception retcode;
    predef_exception che_select();
    register pcb *current;

    current = args->sched->ready; /* hack for interpreter compatibility */
    if ((retcode = che_select(& args->operandstack[0], args->qualifiers,
			      args->sched))
	is Normal)
      args->nextop = current->ip; /* the rest of the hack */
    else
      raise_builtin(retcode);
}

/* che_select is called directly by generated C-code */
predef_exception
che_select(operandstack, qualifier, sched)
object **operandstack;
valcell qualifier;
schedblock *sched;
{    int i, j, label;
    flag open[MAXOPERANDS/2];
    objectp bool, ipobj;
    pcb *current;
    int maxopen;
    dfd_inport *ip;
    flag someconnected;


#ifdef OPCHECK
    for (i = 0; operandstack[i] isnt nil; i += 2) {
      if (operandstack[i] isnt NO_OBJECT)
	assert(OPISTYPE(operandstack[i],inport));
      if (operandstack[i+1] isnt NO_OBJECT)
	assert(OPISTYPE(operandstack[i+1],boolean));
    }
#endif
    current = sched->ready;

    maxopen = -1;
    someconnected = FALSE;
    
    for (i = 0, label = 0; operandstack[i] isnt nil; 
	 i += 2, label++) {
	bool = operandstack[i+1];
	if (bool is NO_OBJECT or bool->value.boolean) {
	    open[label] = TRUE;
	    maxopen = label;
	}
	else {		/* boolean guard exists and is false */
	    open[label] = FALSE;
	    continue;
	}
	
	ipobj = operandstack[i];
	if (ipobj isnt NO_OBJECT)
	  if (ipobj->value.inport->info.inport.queue is nil) {
	      if (ipobj->value.inport->refcount isnt 0)
		someconnected = TRUE;
	      continue;
	  }
	
	/* we've found an open guard */
	
	current->ip = get_elem(qualifier, label).integer;
	return(Normal);
    }
    
    if (maxopen is -1) {	/* no open guards... fall thru to otherwise */
      current->ip++;
      return(Normal);	
    }
    
    /* there are open guards but we need to await a message.  open[i] */
    /* is true for every branch for which there is no guard or the guard */
    /* is true.  */
    
    if (not someconnected) { /* need to wait, but we would wait forever */
	return(Disconnected);
    }
    
    for (i = 0, j = 0; i <= maxopen; i++) 
      if (open[i]) {
	  current->suspend_info.select.waiting_ports[j] = ip =
	    operandstack[i*2]->value.inport;
	  current->suspend_info.select.branch_labels[j] = 
	    get_elem(qualifier, i).integer;
	  j++;
	  
	  ip->info.inport.waiting_owner = current;
      }
    
    current->suspend_info.select.opencount = j;
    current->selecting = TRUE;
    
    sched->suspend(sched, current, nil);
    /* take ourselves off the ready list */
    /* on return ip points to the select */
    return(Normal);
}


NILOP(o_jumpselect)
{
    OPCHK(DstObj,integer);
    if (Dst.integer < 0 or 
	Dst.integer >= (dfd_integer) size_of(args->qualifiers))
      return;			/* not in jump table... fall thru to next op */

    args->nextop = (counter) get_elem(args->qualifiers, Dst.integer).integer;
}
	
