/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
#ifndef lint
static char sccsinfo[] = "@(#)o_bool.c	1.5 2/28/92";
#endif

#include <stdio.h>

#include "ops.h"

#define Dst (args->operandstack[DstPos]->value.boolean)
#define Src (args->operandstack[SrcPos]->value.boolean)
#define Src1 (args->operandstack[Src1Pos]->value.boolean)
#define Src2 (args->operandstack[Src2Pos]->value.boolean)

#define init_bool(objectp, val) (set_init((objectp), dr_boolean), objectp->value.boolean = (val))

extern datarep dr_boolean;

NILOP(o_boolean)
{
    init_bool(DstObj, args->qualifiers.boolean);
				/* for a literal, the value is the qualifier */
				/*  of the operation. */
}

NILOP(o_not)
{
    OPCHK(SrcObj,boolean);
    init_bool(DstObj, ! Src);	/* what could be simpler?  just negate it. */
}


NILOP(o_and)
{
    OPCHK(Src1Obj,boolean);
    OPCHK(Src2Obj,boolean);
    init_bool(DstObj, Src1 and Src2);
}


NILOP(o_or)
{
    OPCHK(Src1Obj,boolean);
    OPCHK(Src2Obj,boolean);
    init_bool(DstObj, Src1 or Src2);
}


status eq_boolean(s1, s2)
valcell s1, s2;
{
  return(s1.boolean ? s2.boolean : (! s2.boolean));
}
