/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* File: Makefile */
/* Author: David F. Bacon */
/* SCCS Info: @(#)Makefile	1.33 2/7/92 */

#include "includefile"

MTYPE = _MTYPE_
EXTRACFLAGS = 	-DMTYPESTRING=\"$(MTYPE)\" $(DLOADFLAGS)

/* Set following to "/usr/lib/debug/malloc.o" to load in malloc_debug support */
MALLOCDEBUG =
LIBS	=	$(LIBDIRS) $(MALLOCDEBUG) -lhermi -lcfunc -lfe \
		$(HROOT)/fe/integrated.o -ll -lcherm -lhaux $(MACHLIBS) \
		$(DLOADLIBS)

LINTLIBS =	-lhaux -lcherm -lcfunc

HDRS	=	$(HROOT)/include/li.h $(HROOT)/include/stdnil.h \
		$(HROOT)/include/sysdep.h $(HROOT)/include/storage.h \
		$(HROOT)/include/ops.h $(HROOT)/include/ops_parm.h recursiv.h \
		$(HROOT)/include/table.h $(HROOT)/include/tblrep.h tablefuncs.h \
		trigger.h shape.h

PDOBJS =	avlsubs.o
PDSRCS =	avlsubs.c

TABLEOBJS=	t_vec.o t_chs.o t_avl.o t_linklist.o
TABLESRCS=	t_vec.c t_chs.c t_avl.c t_linklist.c

OPOBJS	=	o_ubiq.o o_scalar.o o_bool.o o_int.o o_record.o o_enum.o \
		o_ports.o o_nomin.o o_cntl.o o_var.o o_call.o o_prog.o \
		o_bottom.o o_undone.o o_proc.o tbldes.o o_poly.o o_real.o \
		o_escape.o chfunctions.o link_process.o \
		o_table.o $(TABLEOBJS) mainloop.o schedule.o distrib.o pilxdr.o
OPSRCS	=	o_ubiq.c o_scalar.c o_bool.c o_int.c o_record.c o_enum.c \
		o_ports.c o_nomin.c o_cntl.c o_var.c o_call.c o_prog.c \
		o_bottom.c o_undone.c o_proc.c tbldes.c o_poly.c o_real.c \
		o_escape.c chfunctions.c link_process.c \
		o_table.c $(TABLESRCS) mainloop.c schedule.c distrib.c pilxdr.c

MAINOBJS=	main.o
MAINSRCS=	main.c

AUXOBJS	=	excep.o recursiv.o debug.o hxdr.o keycomp.o xdr.o \
		print.o cfunc.o makeroot.o trace.o fakemalloc.o \
		func2op.o opnames.o profile.o hpaths.o
AUXSRCS	=	excep.c recursiv.c debug.c hxdr.c keycomp.c xdr.c \
		print.c cfunc.c makeroot.c trace.c fakemalloc.c \
		func2op.c opnames.c profile.c hpaths.c

OBJECTS	=	$(AUXOBJS) $(OPOBJS) $(PDOBJS)
SOURCES	=	$(AUXSRCS) $(OPSRCS) $(PDSRCS)

LLIBSRC	=	$(SOURCES)

all:	hermes

install:	all
	cp hermes $(HERMES)

pre-fe: libhermi.a

hermes: $(MAINOBJS) libhermi.a $(HROOT)/cfunc/libcfunc.a $(HROOT)/fe/libfe.a \
		$(HROOT)/cherm/libcherm.a $(HROOT)/lib/libhaux.a
	$(CC) -o $@ $(CFLAGS) $(MAINOBJS) chfunctions.o $(LIBS)

libhermi.a: $(OBJECTS)
	ar r libhermi.a $?
	$(RANLIB) libhermi.a

llib-lhermes.ln: hermes
	$(LINT) -Chermes $(LFLAGS) $(LLIBSRC) > /dev/null

lint: llib-lhermes.ln 
	$(LINT) $(LFLAGS) $(MAINSRCS) $(LLIBSRC)

t_chs.c: t_vector.cc 
	sed s/PRAGMA/chs/g <t_vector.cc >t_chs.c

t_vec.c: t_vector.cc 
	sed s/PRAGMA/vec/g <t_vector.cc >t_vec.c

excep.c: excep.ch
	$(CHERM) excep.ch | $(CHERM2) >excep.c

cfunc.c: cfunc.ch
	$(CHERM) cfunc.ch | $(CHERM2) >cfunc.c

makeroot.c: makeroot.ch
	$(CHERM) makeroot.ch | $(CHERM2) >makeroot.c

profile.c: profile.ch 
	$(CHERM) profile.ch | $(CHERM2) >profile.c

func2op.c opnames.c: opcodes.awk $(HROOT)/interface/greencard
	awk -f opcodes.awk $(HROOT)/interface/greencard

$(OBJECTS): $(HDRS)

clean::
	rm -f hermes t_vec.c t_chs.c excep.c cfunc.c \
	  makeroot.c profile.c func2op.c opnames.c opfuncdefs.h

