-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)terminalio.d	1.3 1/6/92

terminalIO: using (predefined)
definitions

  terminalFunctions: record (
    putString: putStringFunc,	-- print a string
    putLine: putStringFunc,	-- print a string plus a newline
    getString: getStringFunc,	-- read a string 
    putChar: putCharFunc,	-- print a character
    getChar: getCharFunc	-- get a character 
  );

  -- putString: Interface for functions that output a string to an I/O
  -- stream
  putStringIntf: callmessage (
    string: charstring
  ) constant (string)
    exit {full}
    exception error {full};

  putStringQ: inport of putStringIntf { init(string) };
  putStringFunc: outport of putStringQ;

  -- putSubString: Interface for functions that write up to a
  -- specified number of characters from a string to an I/O stream
  putSubStringIntf: callmessage (
    string: charstring,
    count: integer		-- in: max chars to write; out: number
				-- of chars actually written
  ) constant (string)
    exit {full}
    exception error {full};
    
  putSubStringQ: inport of putSubStringIntf {full};
  putSubStringFunc: outport of putSubStringQ;
  
  -- putChar: interface for functions that output a single character to
  -- an I/O stream
  putCharIntf: callmessage (
    char: char
  ) constant (char)
    exit {full};

  putCharQ: inport of putCharIntf {full};
  putCharFunc: outport of putCharQ;

  -- putWord: interface for functions that output an integer value as
  -- a single word on an I/O stream
  putWordIntf: callmessage (
    value: integer
  ) constant (value)
    exit {full};

  putWordQ: inport of putWordIntf {full};
  putWordFunc: outport of putWordQ;

  -- getString: interface for functions that read characters from an
  -- I/O stream
  getStringIntf: callmessage (
    string: charstring
  ) exit {full}
    exception endOfInput {};

  getStringQ: inport of getStringIntf {};
  getStringFunc: outport of getStringQ;

  -- getBoundedString: interface for functions that read characters
  -- from an I/O stream but with a bound on how many characters can be
  -- read
  getBoundedStringIntf: callmessage (
    count: integer,		-- number of chars to read
    string: charstring		-- returned string
  ) constant (count)
    exit {full}
    exception endOfInput {init(count)};

  getBoundedStringQ: inport of getBoundedStringIntf {init(count)};
  getBoundedStringFunc: outport of getBoundedStringQ;
  
  -- getChar: interface for functions that read a single character
  -- from an I/O stream
  getCharIntf: callmessage (
    char: char
  ) exit {full}
    exception endOfInput {};

  getCharQ: inport of getCharIntf {};
  getCharFunc: outport of getCharQ;

  -- getWord: interface for functions that read a single word,
  -- interpreted as an integer, from an I/O stream, 
  getWordIntf: callmessage (
    value: integer
  ) exit {full}
    exception endOfInput {};

  getWordQ: inport of getWordIntf {};
  getWordFunc: outport of getWordQ;
  
end definitions
