-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: listuff.d
-- Author: Andy Lowry
-- SCCS Info: @(#)listuff.d	1.7 2/15/92

-- This is the interface to the only really nasty piece of the Hermes
-- system.  The reason it's nasty is that the interface
-- doesn't really tell the full story of what's going on.
-- Specifically, the LIstuff process takes an absprog and an table of LI
-- programs and stuffs the latter into a hidden field of the former.
-- Because it's a hidden field, this interface defininition doesn't
-- mention it at all; instead, it describes a function which discards
-- the LI programs but doesn't touch the absprog.

LIStuff: using (interpform)

definitions

  LIStuff: callmessage (
      absprog: predefined!program,
      LIprogs: interpform!codeMap
    ) constant (absprog)
    exit {full(absprog)};
  LIStuffQ: inport of LIStuff {full};
  LIStuffFn: outport of LIStuffQ;

  -- LIUnstuff does the reverse of LIStuff
  LIUnstuff: callmessage (
      absprog: predefined!program,
      LIprogs: interpform!codeMap
    )
    constant (absprog)
    exit {full};
  LIUnstuffQ: inport of LIUnstuff {full(absprog)};
  LIUnstuffFn: outport of LIUnstuffQ;  

end definitions
