-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)errors.d	1.10 2/16/92

errors:  USING (predefined, positions, type_inference)
DEFINITIONS
-- the errors table gets passed through all phases, each of which inserts any
-- errors or warnings generated.  this is then passed to an error printing 
-- routine for display to the user.

  errors: ordered table of error { full };

  error: record (
    position: position,
    code: errorcode,
    objects: ErrorObjects );

-- errors associated with a particular process id
  procErrors: ordered table of procError { full } ;
  
  procError: record (
    procID: processID,
    error: error
  );

-- these are the different types of absprog objects which can be printed out
-- as part of an error message. 

  ErrorObjectType: enumeration (
    'objectname',
    'attribute',
    'typename',
    'charstring',
    'integer',
    'type_class_function',
    'type_assignment_function',
    'type_inference_function',
    'moduleid',
    'typeid',
    'attributeid',
    'componentid',
    'exceptionid',
    'handlername');

  ErrorObject: variant of ErrorObjectType (
    'objectname' -> objectname: objectname { full },
    'attribute' -> attribute: attribute { full }, 
    'typename' -> typename: typename { full },
    'charstring' -> charstring: charstring { full },
    'integer' -> integer: integer { full },
    'type_class_function' -> type_class_function: type_class_function { full },
    'type_inference_function' -> 
                type_inference_function: type_inference_function { full },
    'type_assignment_function' -> 
       type_assignment_function: type_assignment_function { full },
    'moduleid' -> moduleid: moduleid {full},
    'typeid' -> typeid: typeid {full},
    'attributeid' -> attributeid: attributeid {full},
    'componentid' -> componentid: componentid {full},
    'exceptionid' -> exceptionid: exceptionid {full},
    'handlername' -> handlername: handlername {full}
    );

  ErrorObjects: ordered table of ErrorObject { full };

-------------------------------------------------------------------------------
-------------------- All Possible Compiler-Flagged Errors ---------------------
-------- (except for the hundred or so flagged by definitions checking) -------
-------------------------------------------------------------------------------

  errorcode: ordered enumeration (

    -- CATCH-ALL
    'general error',
	-- this error is used temporarily in situations where a more
	-- specific error code has not been defined or implemented.
	-- It has one error object: an error message (charstring)

    -- DEFINITIONS ERRORS
    'definition error',
    -- This is generated in the process checkdefs or abbrev_expand.
    -- It has an arbitrary number of objects: a moduleid idetifying
    -- the relevant definitions module, a series of 
    -- error messages (charstrings) to be concat'ed together (in reverse
    -- of their order in the table), a typeid or attributeid, and possibly a 
    -- componentid or exceptionid.  The error messages need not be 
    -- contiguous in the table.
    
    -- PARSING ERRORS

    -- RESOLUTION ERRORS

    -- TYPE ERRORS
    'type inference mismatch',  
        -- this error occurs when a type inference rule deduces a type
        -- for an object that doesn't match its previous type.  it has
        -- four associated error objects: op1 (objectname),
        -- previous_type (typename), op2 (objectname), inferred_type
        -- (typename).  this means that although the operand op1 has
        -- type previous_type, operand op2 causes op1 to get the
        -- conflicting type inferred_type.  NOTE that previous_type
        -- may be the type given in the program or may be a previously
        -- inferred type.

    'type assignment mismatch',
        -- this error occurs when an assignment rule is violated.  It
        -- has three associated error objects: obj (objectname),
        -- obj_type (typename), assigned_type (typename).  It means
        -- that the type (obj_type) of the obj clashes with the
        -- assigned type.

    'class rule violation',
        -- this error occurs when a class rule is violated.  It has
        -- three associated error objects: obj (objectname), type
        -- (typename), class_function (type_class_function).  It means
        -- that obj having type violates the class function.  

    'named literal not found',
        -- this occurs when the string specified by the a named
        -- literal is not an enumeration value or a boolean value of
        -- the inferred type.  It has two associated error objects:
        -- type (typename), the inferred type of the named literal (it
        -- will always be either an enumeration type or a boolean
        -- type), and literal (charstring), the given literal

    'incorrect number of args',
        -- this occurs when the number of actual args to the function
        -- call does not match the number of formals.  It has 3 number
        -- of associated error objects: func_name (objectname),
        -- expected_number (integer), actual_number (integer).  This
        -- mean that the func_name being called has actual_number of
        -- args, instead of the expected_number

    'arg of incorrect type',
        -- this occurs when a the type of a call argument doesn't
        -- match its expected type.  If has 4 error objects:
        -- argument_position (integer), actual_type (typename),
        -- expected_type (typename), and called port (objectname).

    'overlapping args',
        -- this occurs when a call has two args that are the same
        -- object.  It has two error objects: obj (objectname), the
        -- argument that appears twice, and port (objectname), the
	-- called output port

    'outport expected',
        -- this occurs when a call is attempted over something other
        -- than an outport connected to an inport of type callmessage.
        -- It has one error object, the object which is being called;

    'uninferred type',
        -- this error occurs when a temporary's type cannot be
        -- inferred from the inference rules.  It has one associated
        -- error object: obj (objectname), the temporary with an
        -- uninferred type.

    'variantcomponent',
        -- this occurs when the 2nd argument to `dissolve', or the
        -- first argument to 'reveal' or 'unite' is not of the form
        -- x1.x2....xn where x(n-1) is of type variant.  i.e.,
        -- x1.x2....xn is a component of a variant.  It has one
        -- associated error object: obj, the argument of the wrong
        -- type.

    -- TYPESTATE ERRORS
    'DeadCode',
        -- a statement with no normal return isn't the last statement
        -- in the clause, or something pathological like an expression
        -- block terminating with an EXIT statement was coded

    'DeadHandler',
        -- special case of deadcode, broken out because it takes a
        -- 'HandlerName' error object parameter

    'Constant',
        -- operation attempts to change the value of a constant

    'Position',
        -- operation attempts to do POSITION of something which has no
        -- position

    'NotAsserted',
        -- a required attribute is missing from the typestate

    'NotLowerable',
        -- an attribute must be dropped but it can't (e.g. it's a
        -- MINIMUM callmessage component)

    'CannotAdd',
        -- post-condition adds an attribute which is illegal to add

    'CannotDrop',
        -- post-condition drops an attribute which is illegal to drop

    'UninitializedResult',
        -- WHERE or WHILE clause evaluates to uninitialized

    'UnsupportedAttribute'
	-- FULL attributes are not yet allowed in process modules

    -- CODE GENERATION ERRORS
    -- (None)

  ); -- end errorcode



END DEFINITIONS
