/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)ops.h	1.5 2/17/92 */

#ifndef ops_included

#include "li.h"

#include "../cherm/datarep.h"

#define NILOP(op)  void op(args) argblock *args;
#ifdef OPCHECK
#  include <stdio.h>
#  include <assert.h>
#  define OPISTYPE(op, type) ((op)->tsdr->number is dr_/**/type.number)
#  define OPCHK(op,type) assert(OPISTYPE(op,type))
#else
#  define OPCHK(op,type)
#endif

/* raise an exception */

#define raise_builtin(x) raise_predefined(x, args)

void raise_predefined();

/* positions of operands in the operandstack */

#define DstPos 0
#define SrcPos 1
#define Src1Pos 1
#define Src2Pos 2

/* operand object pointers */

#define DstObj (args->operandstack[DstPos])
#define SrcObj (args->operandstack[SrcPos])
#define Src1Obj (args->operandstack[Src1Pos])
#define Src2Obj (args->operandstack[Src2Pos])

#define set_bottom(objectp) ((objectp)->tsdr = &dr_bottom)

#define set_init(objectp, rep) ((objectp)->tsdr = &rep)

#endif
#define ops_included
