-- (C) Copyright International Business Machines Corporation 14 December
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)store_program.p	1.2 6/20/91

store_program: using (common, load, objectio, predefined, storeprogram) 
  process (initport: storeprogram_init_q)

declare

  init: storeprogram!storeprogram_init_intf;
  write: writeobject_func;
  Q: storeQ;
  request: storeIntf;
  polyprog: polymorph;

begin

  receive init from initport;		-- initialization
  write := init.writeobj;
  new Q;
  connect init.store to Q;
  return init;
  discard initport;

  while boolean#'true' repeat		-- service loop

    block begin

      receive request from Q;
      wrap program#(copy of request.program) as polyprog;
      call write(request.modulename, polyprog);
      return request;

    on (writeobject_intf.file_not_writeable,
	  writeobject_intf.object_not_writeable,
	  writeobject_intf.Discarded)
      return request exception cantStoreProgram;
    end block;

  end while;

end process
