-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)pathreadobj.p	1.3 1/11/92

pathreadobj: using (predefined, unix, objectio, findfile, pathreadobj,
  common) 
  process (initport: pathreadobj_init_q)

declare
  init: pathreadobj!pathreadobj_init_intf;
  pathfinder: findfile_func;
  readobj: readobject_func;
  readobjq: readobject_q;
  request: readobject_intf;
  filename: charstring;

begin
  receive init from initport;		-- initialization
  pathfinder := init.pathfinder;
  readobj := init.readobj;
  new readobjq;
  connect init.pathreadobj to readobjq;
  return init;
  discard initport;

  while boolean#'true' repeat		-- service loop
    block begin
      receive request from readobjq;
      request.object <- polymorph#(readobj(
	  charstring#(pathfinder(request.filename, 
	      fileAccessType#'read'))));
      return request;

    on (readobject_intf.file_not_found, findfile_intf.file_not_found)
      return request exception file_not_found;

    on (readobject_intf.file_not_readable)
      return request exception file_not_found;

    end block;
  end while;
end process
