-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: fixdefs.p
-- Author: Rob Strom
-- SCCS Info: @(#)fixdefs.p	1.12 1/9/92

-- Main Program to post-process a definitions module
-- getting rid of all the uses of FULL and expanding them to INIT
-- filling in minimum formal typestate for callmessages

fixdefs: using (common, main, filedef, parse,
  inferredtype, interpform,  
  objectIO, fixdefs, checkDefs, errors, stdenv)
  process ( initport: mainQ )

declare
  init: main;
  junk: charstring;
  empty: empty; -- empty type
  filename: charstring; -- of old/new definition
  filename2: charstring; -- of imported definitions
  arbobj: polymorph;
  badModule: charstring;
  defMaps: definitions_printmappings;
  procMaps: executable_printmappings;
  poly: polymorph;
  Nothing: empty;
  definitions: definitions_modules; -- all the definitions modules
  filedef: filed_definition; -- definition being loaded
  ToBeFixed: filed_definition;  -- the definition to be fixed
  id: moduleid;	-- its unique identifier
  imports: module_printmap; -- the definitions needed by the module being loaded
  imported: module_printmap; -- the definitions we have already loaded
  neededModule: module_printrec; -- the description of a module we need to import
  checkdefs: checkdefsFn;
  errors: errors;
  fixabbrevs: FixdefsOutport;
  shorten: FixdefsOutport;
  predef_defmod_typename: predefined!typename;
  predef_program_typename: predefined!typename;
  thismodule: predefined!definitions_module;
  stdenv: stdenv;

begin 
  receive init from initport;

    -- mock up an old-style stdenv for processes we need to call
    new stdenv;
    unwrap stdenv.load from init.rm.get("load", "") {init};
    unwrap stdenv.pathload from init.rm.get("pathLoad", "") {init};
    unwrap stdenv.readobj from init.rm.get("readObj", "") {init};
    unwrap stdenv.pathReadObj from init.rm.get("pathReadObj", "") {init};
    unwrap stdenv.writeObj from init.rm.get("writeObj", "") {init};
    unwrap stdenv.libWriteObj from init.rm.get("libWriteObj", "") {init};
    unwrap stdenv.store from init.rm.get("store", "") {init};
    unwrap stdenv.libStore from init.rm.get("libStore", "") {init};
    unwrap stdenv.getCwd from init.rm.get("getCwd", "") {init};
    unwrap stdenv.setCwd from init.rm.get("setCwd", "") {init};
    stdenv.terminal := init.terminal;

-- Load the code for fixdefsint
  fixabbrevs <- procedure of stdenv.pathLoad("abbrev_expand");
  shorten <- procedure of stdenv.pathLoad("do_shorten");
  checkdefs := procedure of stdenv.pathLoad("checkdefs");
  
-- Main loop: process each definition
-- 1. build an empty list of definitions
-- 2. read the definition to be fixed
-- 4. insert it into the full definitions list
-- 5. insert its dependencies into the needed module list
-- 6. drag in dependent modules until none needed
-- 7. fix the definition
-- 10. write the fixed definition out
  for string in init.argv where (position of string > 1) inspect
  
  block begin
  call init.terminal.putString(string | ":");
  
  -- 1.
  new definitions;
  new defMaps;
  -- 2.
  filename := string | ".do";
  BLOCK
    BEGIN
      call init.terminal.putstring(" load[" | filename | "]");
      arbobj <- polymorph#(Stdenv.pathReadObj(filename));
      unwrap ToBeFixed from arbobj { init, init(definitions_module), init(defmap), init(procmaps), init(direct_imports), init(definitions_module.id), init(definitions_module.type_definitions), init(definitions_module.attr_definitions), checkeddefinitions(definitions_module), init(defmap.id), init(defmap.name), init(defmap.types), init(defmap.attributes), init(defmap.components), init(defmap.exceptions) };
    ON (ReadObject_Intf.File_Not_Found)
          call init.terminal.putLine(" ERRORS");
          call init.terminal.putString(charstring#"Definitions module '");
          call init.terminal.putString(string);
          call init.terminal.putLine(charstring#"' not found.");
      EXIT PrematureTermination;
    END BLOCK;
  -- 4. 
  insert copy of ToBeFixed.definitions_module into definitions;
  insert copy of ToBeFixed.defmap into defMaps;
  -- 5. 
  imports := ToBeFixed.Direct_Imports;
  new imported;
  REMOVE NeededModule FROM M IN imports WHERE(M.Name = string);
  INSERT NeededModule INTO imported;
  -- 6. 
  while boolean#(integer#(size of imports) <> integer#0) repeat
    block begin
      -- get the name of a module which needs to be imported
      remove NeededModule from map in imports where (boolean#'true');

      -- read the definition from disk
      filename2 <- charstring#(NeededModule.name | charstring#".do");
      arbobj <- polymorph#(Stdenv.pathReadObj(filename2));
      unwrap filedef from arbobj { init, init(definitions_module), init(defmap), init(procmaps), init(direct_imports), init(definitions_module.id), init(definitions_module.type_definitions), init(definitions_module.attr_definitions), checkeddefinitions(definitions_module), init(defmap.id), init(defmap.name), init(defmap.types), init(defmap.attributes), init(defmap.components), init(defmap.exceptions) };

      -- verify that the moduleid on disk matches the moduleid expected
      if boolean #(filedef.definitions_module.id <> NeededModule.id) 
        then
          call init.terminal.putString(charstring#"Definitions module '");
          call init.terminal.putString(NeededModule.Name);
          call init.terminal.putLine(charstring#"' is inconsistent with disk.");
          EXIT PrematureTermination;
        end if;

      -- append the definitions module and definitions printmap
      insert filedef.definitions_module into definitions;
      insert filedef.defmap into defMaps;

      -- put the module name into the set of modules imported
      insert NeededModule into imported;	-- remember that we imported this one
      
      -- for each module imported by the definition:
      -- if it hasn't been imported yet, add it to the list of needed imports
      -- if it has been imported already, verify that the expected moduleid matches the loaded moduleid
      for map in filedef.direct_imports where (boolean#'true') inspect 
	block begin
	  inspect ImportedModule IN Imported WHERE(boolean # (ImportedModule.Name = Map.Name))
	    BEGIN
	      IF boolean #(ImportedModule.Id <> Map.Id)
	        THEN
                  call init.terminal.putString(charstring#"Definitions module '");
                  call init.terminal.putString(ImportedModule.Name);
                  call init.terminal.putLine(charstring#" is inconsistent.");
		  EXIT PrematureTermination;
	        END IF;
	    END INSPECT;
	on (NotFound)
	  BLOCK
	    BEGIN
	      insert module_printrec#(copy of map) into imports;
	    ON (DuplicateKey)
	    END BLOCK;
	end block;
      end for;

      discard filedef.direct_imports;

    on (readobject_intf.file_not_found)  
      call init.terminal.putString(charstring#"Definitions module '");
      call init.terminal.putString(NeededModule.Name);
      call init.terminal.putLine(charstring#"' was not found.");
      EXIT PrematureTermination;
    end block;
  end while;

  id := ToBeFixed.definitions_module.id;  
  -- initialize the typenames from predefined
  if string = "predefined" then
      inspect def_map in defmaps[id]
        begin
          new predef_defmod_typename;
          predef_defmod_typename.moduleid := id;
          new predef_program_typename;
          predef_program_typename.moduleid := id;
          block
            begin
              inspect defmod_printrec in def_map.types where
                     (defmod_printrec.name = "definitions_module")
                begin
                  predef_defmod_typename.typeid := defmod_printrec.id;
                end inspect;
              inspect program_printrec in def_map.types where
                     (program_printrec.name = "program")
                begin
                  predef_program_typename.typeid := program_printrec.id;
                end inspect;
            on (NotFound)
              call init.terminal.putLine(" ERRORS - run dcom for details");
              exit PrematureTermination;
            end block;
        end inspect;
    else
      predef_defmod_typename := \typename predefined!definitions_module\;
      predef_program_typename := \typename predefined!program\;
    end if;

  remove thismodule from definitions[id];

  -- expand abbreviations
  call init.terminal.putString(" fixabbrevs");
  call fixabbrevs(stdenv, thismodule, definitions, errors);
  if (size of errors <> 0) then
      call init.terminal.putLine(" ERRORS - run dcom for details");
      exit PrematureTermination;
    end if;

  -- run checkdefs
  call init.terminal.putString(" checkdefs");
  call checkdefs(stdenv, thismodule, definitions,
      (evaluate typenames: checkdefs!typename_rec from
            new typenames;
            typenames.defmod := predef_defmod_typename;
            typenames.program := predef_program_typename;
          end),
      errors);
  if size of errors <> 0 then
      call init.terminal.putLine(" ERRORS - run dcom for details");
      exit PrematureTermination;
    end if;

  -- do shortening
  call init.terminal.putString(" shorten");
  call shorten(Stdenv, thismodule, definitions, errors);
  if size of errors <> 0 then
      call init.terminal.putLine(" ERRORS - run dcom for details");
      exit PrematureTermination;
    end if;


  -- fix up filedef ToBeFixed now that checkdefs is finished
  ToBeFixed.definitions_module <- thismodule;
  ToBeFixed.defmap <- definitions_printmap#(defmaps[id]);
 
  --10.
  call init.terminal.putString(" store[" | filename | "]");
  wrap ToBeFixed as arbobj;
  call Stdenv.writeObj(filename, arbobj);
  
----------- Done
  call init.terminal.putLine("");

  on exit(PrematureTermination)
  end block;

  end for;

  return init;

end process
