-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: fixdefs.p
-- Author: Rob Strom
-- SCCS Info: @(#)fixdefs.p	1.1 7/28/89

-- Program to post-process a definitions module

do_shorten: using ( inferredtype, interpform, objectIO, checkdefs_internal,
    fixdefs, errors, positions)
  process ( initport: FixdefsInport )
    
  declare
    FP: FixdefsCall; -- formal parameters
    shorten: FixFullOutport; -- program to eliminate attributes implied 
                             -- by init(cm)
    modules: module_table;  -- definitions modules for resolution
    newdefinition: type_definition; -- definition being recreated
    newdefinitions: type_definitions; -- module being recreated
    newcasemapping: partitionset; 
    newpartition: partition_info;
    cmtype: typename;
    newexceptionspecifications: exception_specifications;
    newexceptionspecification: exception;
  
    errorTemplate: error;
  begin 
    receive FP from initport;

    -- no errors generated in this module, but we must initialize
    new FP.errors;
    new errorTemplate;
    errorTemplate.code := 'definition error';
    unite errorTemplate.position.apos from 
      (evaluate pos: aposition from
            new pos; 
            pos.clause := unique;
            pos.statement := unique;
          end);
    new errorTemplate.objects;
    
    -- Load the code for subprograms
    shorten <- PROCEDURE OF fp.std.pathload("shorten");

    -- build table of definitions modules consisting of the checked modules
    -- plus the one we're shortening
    new modules;
    for defmod in fp.definitions where ('true')
      inspect
        insert copy of defmod into modules;
      end for;
    insert copy of fp.ToBeFixed into modules;
    
    -- This is done in abbrev_expand: 
    -- Pass I: fixing full/init(*) and defaulting minimum typestate
    -- 7. fix the full in all formal TS's in the module to be fixed
    -- 8. for callmessages,
    --    if the user didn't supply a minimum
    --    (which we infer by empty formal-typestate), then
    --    generate one in the following way:
    --    init(*)
    --    For each constant parameter P, include init(P) if it's in exit TS.
    --    If P is a record/cm, recursively include components of P if in 
    --    exit TS.
    
  
    -- We do this here:  
    -- Pass II: suppressing attributes already implied by init(cm)
    -- 9. for each formal TS in the module to be fixed, except CM minimums
    --   identify attributes of the form init(x), where x is a callmessage,
    --    (a) expand (recursively) all implied attributes
    --    (b) delete all implied attributes
    -- End pass II
  

    new newdefinitions;
    while (size of FP.ToBeFixed.type_definitions > 0)
      repeat
        remove newdefinition from n in FP.ToBeFixed.type_definitions where('true');
        select (case of newdefinition.specification)
          where('varianttype')
            reveal newdefinition.specification.variant_info;
            new newcasemapping;
            while (size of newdefinition.specification.variant_info.case_mapping > 0)
              repeat
                remove newpartition from p in 
                   newdefinition.specification.variant_info.case_mapping 
                   where('true');
                inspect componentdeclaration in 
                       newdefinition.component_declarations 
                       where(componentdeclaration.id = newpartition.component_id)
                  begin
                    call shorten(Modules,
                        newpartition.case_typestate,
                        componentdeclaration.type,
                        errorTemplate,
                        FP.errors);
                  end inspect;
                insert newpartition into newcasemapping;
              end while;
            newdefinition.specification.variant_info.case_mapping <- newcasemapping;
          where('inporttype')
            reveal newdefinition.specification.inport_info;
            call shorten(Modules,
                newdefinition.specification.inport_info.message_typestate,
                newdefinition.specification.inport_info.message_type,
                errorTemplate,
                FP.errors);
          where('tabletype')
            reveal newdefinition.specification.table_info;
            call shorten(Modules,
                newdefinition.specification.table_info.element_typestate,
                newdefinition.specification.table_info.element_type,
                errorTemplate,
                FP.errors);
          where('callmessagetype')
            reveal newdefinition.specification.callmessage_info;
            new cmtype;
            cmtype.moduleid := FP.ToBeFixed.id;
            cmtype.typeid := newdefinition.id;
            call shorten(Modules,
                newdefinition.specification.callmessage_info.normal,
                cmtype,
                errorTemplate,
                FP.errors);
            new newexceptionspecifications;
            while (size of newdefinition.specification.callmessage_info.exception_specifications > 0)
              repeat
                remove newexceptionspecification from e in 
                   newdefinition.specification.callmessage_info.exception_specifications 
                   where('true');
                IF not (newexceptionspecification.exceptionid = 
                           newdefinition.specification.callmessage_info.minimum)
                  THEN
                    call shorten(Modules,
                        newexceptionspecification.post_typestate,
                        cmtype,
                        errorTemplate,
                        FP.errors);
                  END IF;
                insert newexceptionspecification into newexceptionspecifications;
              end while;
            newdefinition.specification.callmessage_info.exception_specifications <- newexceptionspecifications;
            
          otherwise
          end select;
        insert newdefinition into newdefinitions;
      end while;
    
    FP.ToBeFixed.type_definitions <- newdefinitions;
    
    return FP;
    
  end process
