-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: checkconstraints.p
-- Author: Jim Russell
-- SCCS Info: @(#)checkconstraints.p	1.4 1/9/92

-- process to check constraint definitions

checkconstraints: using (checkdefs_internal, errors, positions)
  process(q: checkconstraintsQ)
    
  declare
    args: checkconstraints;
    error: error;
    errObj: errorObject;
    
    checkcirc: checkCircular_typestateFn;
  begin
    receive args from q;
    
  inspect module in args.defs[args.id] begin
        
    for attdef in module.attr_definitions[] inspect
      block begin
        -- NYI: check attdef.execution_environment
        -- we need the table of inferred types generated by the type
        -- checker to check that the return variable is of type
        -- boolean.
        -- NotFound won't happen here when we have above check.
        inspect mscope in attdef.execution_environment.scopes[attdef.execution_environment.main_scope]
          begin
            if size of attdef.parameters = 0 then
                error := args.errorTemplate;
                unite errobj.charstring from 
                "constraint defined with no arguments";
                insert errobj into error.objects;
                unite errobj.attributeid from copy of attdef.attributeid;
                insert errobj into error.objects;
                insert error into args.errors;
              else
                for param in attdef.parameters[] inspect
                    block
                      begin
                        inspect decl in mscope.declarations[param]
                          begin
                            -- formal typestate checking assumes that 
                            -- case of decl.typename = 'named'
                            if not (case of decl.typename = 'named') then
                                error := args.errorTemplate;
                                unite errobj.charstring from 
                                "attribute parameter's declaration doesn't have 'named' optional_typename";
                                insert errobj into error.objects;
                                unite errobj.attributeid from copy of attdef.attributeid;
                                insert errobj into error.objects;
                                insert error into args.errors;
                              end if;
                          end inspect;
                      on (NotFound)
                        error := args.errorTemplate;
                        unite errobj.charstring from 
                        "attribute definition parameter not found in main scope of execution environment";
                        insert errobj into error.objects;
                        unite errobj.attributeid from copy of attdef.attributeid;
                        insert errobj into error.objects;
                        insert error into args.errors;
                      end block;
                  end for;
              end if;
            if attdef.returnvalue.root.scope = attdef.execution_environment.main_scope 
              then
                block
                  begin
                    inspect decl in mscope.declarations[attdef.returnvalue.root.root]
                      begin
                        -- NYI: type of decl.typename = predefined!boolean
                        -- This may be an unnamed typename, so we may need 
                        -- info from the execution_environment check above.
                      end inspect;
                  on (notfound)
                    error := args.errorTemplate;
                    unite errobj.charstring from 
                    "attribute's returnvalue not found in main scope";
                    insert errobj into error.objects;
                    unite errobj.attributeid from copy of attdef.attributeid;
                    insert errobj into error.objects;
                    insert error into args.errors;
                  end block;
              else
                error := args.errorTemplate;
                unite errobj.charstring from 
                "attribute's returnvalue's scope not main scope";
                insert errobj into error.objects;
                unite errobj.attributeid from copy of attdef.attributeid;
                insert errobj into error.objects;
                insert error into args.errors;
              end if;
            if size of attdef.returnvalue.components <> 0 then
                error := args.errorTemplate;
                unite errobj.charstring from 
                "attribute's returnvalue has components; should be boolean";
                insert errobj into error.objects;
                unite errobj.attributeid from copy of attdef.attributeid;
                insert errobj into error.objects;
                insert error into args.errors;
              end if;
          end inspect;
         on (NotFound)
           print charstring#"Whoa! mscope not found in attdef.execution_environment";
         on (others)
           print charstring#"Whoa! unexpected others in first block of checkconstraints";
           exit die;
         end block;
        -- check pretypestate
        --   1) check that all objectnames of each attribute point to main
        --      scope.
        --   2) check that all objectnames of each attribute point to a
        --      rootid in attdef.parameters.
        --   3) make sure no circular attribute dependencies in typestate. 
        --   4) check the typestate like a formal typestate (sort of)
        
        -- procedure for cirularity test
        -- Note that we assume that once we reference a constraint
        -- outside this module, we can't have a circularity.
        -- This is true unless at some point we are allowed mutually
        -- recursive definitions modules.
        checkcirc <- procedure of process (init: checkCircular_typestateQ)
          declare
            args: checkCircular_typestate;
          begin
            receive args from init;
            for attr in args.ts[] inspect
                block
                  begin
                    if case of attr.name = 'constraint' then
                        reveal attr.name.constraint;
                        if attr.name.constraint.moduleid = args.id then
                            call (checkCircular_typestateFn#(create of currentprogram))
                               (evaluate ts:predefined!typestate from
                                    inspect adef in args.def.attr_definitions [attr.name.constraint.attributeid]
                                      begin
                                        ts := adef.pretypestate;
                                      end inspect;
                                  end,
                                args.id,
                                args.def,
                                evaluate newseen:seenlist from
                                    newseen := args.seen;
                                    insert copy of attr.name.constraint.attributeid into newseen;
                                  end);
                          end if;
                      end if;
                  on (NotFound)
                    -- bogus attributeid. skip and continue.
                  end block;
              end for;
            return args;
          on (checkCircular_typestate.error, DuplicateKey)
            return args exception error;
          on (Disconnected)
            -- The previous iteration who created us got blown away before
            -- calling us (by NotFound or DuplicateKey in evaluate blocks),
            -- so let's just die quietly.
          on (others)
            print charstring#"Whoa! unexpected others in checkcirc";
          end process;
        
        -- 3)
        block
          begin
            call checkcirc (attdef.pretypestate,
                args.id,
                args.defs[args.id],
                evaluate newseen:seenlist from
                    new newseen;
                    insert copy of attdef.attributeid into newseen;
                  end);
          on (checkCircular_typestate.error)
                error := args.errorTemplate;
                unite errobj.charstring from 
                "circularity in dependencies among user-defined constraints";
                insert errobj into error.objects;
                unite errobj.attributeid from copy of attdef.attributeid;
                insert errobj into error.objects;
                insert error into args.errors;
          end block;
        
      
        -- 1), 2), and 4)
        block
            -- We check the typestate by building corresponding
            -- formal typestates (indexed by root variables)
            -- and calling checkformaltypestate on them.
            -- Any constraint attributes are not put in the
            -- constructed formal typestate, but are checked
            -- separately.
          declare
            formtstable: formtstable;
            entry: formtsentry;
            zformattr: predefined!formal_attribute;
            errsize: integer;
          begin
            inspect mscope in attdef.execution_environment.scopes[attdef.execution_environment.main_scope]
              begin
                new formtstable;
                for attr in attdef.pretypestate[] inspect
                    if case of attr.name <> 'constraint' 
                      then
                        if size of attr.objects = 0 then
                            error := args.errorTemplate;
                            unite errobj.charstring from 
                            "attribute of constraint's typestate with no arguments";
                            insert errobj into error.objects;
                            unite errobj.attributeid from copy of attdef.attributeid;
                            insert errobj into error.objects;
                            insert error into args.errors;
                          else
                            errsize <- size of args.errors;
                            new zformattr;
                            new zformattr.parameters;
                            for obj in attr.objects[] inspect
                                if obj.root.scope <> attdef.execution_environment.main_scope 
                                  then
                                    error := args.errorTemplate;
                                    unite errobj.charstring from 
                                    "scope of object in attribute of constraint pretypestate not main scope";
                                    insert errobj into error.objects;
                                    unite errobj.attributeid from copy of attdef.attributeid;
                                    insert errobj into error.objects;
                                    insert error into args.errors;
                                  else
                                    if not exists of par in attdef.parameters where 
                                           (par = obj.root.root)
                                      then
                                        error := args.errorTemplate;
                                        unite errobj.charstring from 
                                        "object of attribute in constraint pretypestate not a parameter";
                                        insert errobj into error.objects;
                                        unite errobj.attributeid from copy of attdef.attributeid;
                                        insert errobj into error.objects;
                                        insert error into args.errors;
                                      else
                                        -- check both case's arguments
                                        if position of obj > 0 and
                                               case of attr.name = 'case' then 
                                            -- too many objects for non case attribute
                                            -- will be caught by checkformaltypestate
                                            inspect obj0 in attr.objects[0] begin
                                                if obj0.root <> obj.root then
                                                    error := args.errorTemplate;
                                                    unite errobj.charstring from 
                                                    "arguments to 'case' in constraint pretypestate have different roots";
                                                    insert errobj into error.objects;
                                                    unite errobj.attributeid from copy of attdef.attributeid;
                                                    insert errobj into error.objects;
                                                    insert error into args.errors;
                                                  end if;
                                              end inspect;
                                          end if;
                                        insert copy of obj.components 
                                           into zformattr.parameters;
                                      end if;
                                  end if;
                              end for;
                            if size of args.errors = errsize
                              then
                                inspect obj in attr.objects[0]
                                  begin
                                    zformattr.attribute_name := attr.name;
                                    block
                                      begin
                                        remove entry from formtstable[obj.root.root];
                                        insert zformattr into entry.ts;
                                        insert entry into formtstable;
                                      on(NotFound)
                                        block
                                          declare
                                            newentry: formtsentry;
                                          begin
                                            new newentry;
                                            newentry.id := obj.root.root;
                                            inspect dec in mscope.declarations[obj.root.root]
                                              begin
                                                reveal dec.typename.typename;
                                                newentry.basetype := 
                                                   dec.typename.typename;
                                              end inspect;
                                            new newentry.ts;
                                            insert zformattr into newentry.ts;
                                            insert newentry into formtstable;
                                          on (caseError)
                                            -- dec.typename not in case 'named'.
                                            -- This is checked above; do nothing here.
                                          on (notfound)
                                            -- Parameter with rootid =
                                            -- obj.root.root not defined in
                                            -- mscope.  This is caught above,
                                            -- so no error here.
                                          end block;
                                      end block;
                                  end inspect;
                              end if;
                          end if;
                      else
                        -- check constraints; copied from checkFormal_typestate
                        reveal attr.name.constraint;
                        block
                          declare
                            newattr: predefined!attribute;
                            empty: empty;
                            -- ordinarily I'd use inspects instead of
                            -- the following temporary variables, but
                            -- if the nesting level gets too deep, we
                            -- used to get yacc stack overflow
                            defmod: predefined!definitions_module;
                            adef: predefined!attr_definition;
                          begin
                            new newattr;  -- make sure newattr exists
                            
                            defmod <- args.defs[attr.name.constraint.moduleid];
                            adef <- defmod.attr_definitions[attr.name.constraint.attributeid];
                            if size of adef.parameters =
                                   size of attr.objects
                              then
                                -- could have not found here
                                block
                                  declare
                                    -- temp variable, as above
                                    ascope: predefined!scope;
                                  begin
                                    ascope <- adef.execution_environment.scopes[adef.execution_environment.main_scope];
                                    for obj in attr.objects[] inspect
                                        if obj.root.scope <> attdef.execution_environment.main_scope 
                                          then
                                            error := args.errorTemplate;
                                            unite errobj.charstring from 
                                            "scope of object in constraint attribute of constraint pretypestate not main scope";
                                            insert errobj into error.objects;
                                            unite errobj.attributeid from copy of attdef.attributeid;
                                            insert errobj into error.objects;
                                            insert error into args.errors;
                                          else
                                            if not exists of par in attdef.parameters where 
                                                   (par = obj.root.root)
                                              then
                                                error := args.errorTemplate;
                                                unite errobj.charstring from 
                                                "object of constraint attribute in constraint pretypestate not a parameter";
                                                insert errobj into error.objects;
                                                unite errobj.attributeid from copy of attdef.attributeid;
                                                insert errobj into error.objects;
                                                insert error into args.errors;
                                              else
                                                block
                                                  declare
                                                    prev: predefined!typename;
                                                  begin
                                                    inspect dec in mscope.declarations[obj.root.root]
                                                      begin
                                                        reveal dec.typename.typename;
                                                        prev := dec.typename.typename;
                                                        call args.checkComp_list(obj.components,
                                                            prev,
                                                            args.defs,
                                                            evaluate errtem: error from
                                                                block declare
                                                                    errobj2: errorobject;
                                                                  begin
                                                                    errtem := args.errortemplate;
                                                                    unite errobj2.charstring from 
                                                                    " of constraint attribute in constraint pretypestate";
                                                                    insert errobj2 into errtem.objects;
                                                                    unite errobj2.attributeid from copy of attdef.attributeid;
                                                                    insert errobj2 into errtem.objects;
                                                                  end block;
                                                              end,
                                                            args.errors);
                                                        -- do type check
                                                        inspect decl in ascope.declarations[adef.parameters[position of obj]]
                                                          begin
                                                            reveal decl.typename.typename;
                                                            if decl.typename.typename 
                                                                   <> prev 
                                                              then
                                                                error := args.errorTemplate;
                                                                unite errObj.charstring from 
                                                                "argument of wrong type in constraint attribute of constraint pretypestate";
                                                                insert errObj into error.objects;
                                                                unite errobj.attributeid from copy of attdef.attributeid;
                                                                insert errobj into error.objects;
                                                                insert error into args.errors;
                                                              else
                                                                unite newattr.name.init from empty;
                                                                new newattr.objects;
                                                                insert copy of obj into newattr.objects;
                                                                if not exists of attdef.pretypestate[newattr]
                                                                  then
                                                                    error := args.errorTemplate;
                                                                    unite errObj.charstring from
                                                                    "argument of constraint attribute not init in constraint pretypestate";
                                                                    insert errObj into error.objects;
                                                                    unite errobj.attributeid from copy of attdef.attributeid;
                                                                    insert errobj into error.objects;
                                                                    insert error into args.errors;
                                                                  end if;
                                                              end if;
                                                          end inspect;
                                                      end inspect;
                                                  on (CaseError) 
                                                    -- dec.typename not in case typename, or
                                                    -- decl.typename not in case typename, so
                                                    -- either caught above or where
                                                    -- constraint was defined.
                                                    -- Don't print error here.
                                                  on (CheckComponent_List.Error)
                                                    -- do nothing
                                                  on (notfound)
                                                    -- Parameter of attdef
                                                    -- with rootid =
                                                    -- obj.root.root not def in
                                                    -- mscope.  Caught above,
                                                    -- so no error here.
                                                    -- OR Parameter of adef
                                                    -- in position of obj
                                                    -- not definend in ascope.
                                                    -- Will be caught when
                                                    -- adef checked.
                                                  end block;
                                              end if;
                                          end if;
                                      end for;
                                    -- check that constraint's
                                    -- minimum typestate is here
                                    for cattr in adef.pretypestate[] inspect
                                        block
                                          begin
                                            -- build appropriate typestate
                                            newattr.name := cattr.name;
                                            new newattr.objects;
                                            for obj in cattr.objects[] inspect
                                                insert (evaluate newobj: predefined!objectname from
                                                        new newobj;
                                                        inspect attrobj in attr.objects[position of rid in adef.parameters where (rid = obj.root.root)]
                                                          begin
                                                            newobj.root := attrobj.root;
                                                            newobj.components := attrobj.components | obj.components;
                                                          end inspect;
                                                      end)
                                                   into newattr.objects;
                                              end for;
                                            if not exists of attdef.pretypestate[newattr]
                                              then
                                                error := args.errorTemplate;
                                                unite errObj.charstring from
                                                "part of constraint's typestate not present in constraint pretypestate";
                                                insert errObj into error.objects;
                                                unite errobj.attributeid from copy of attdef.attributeid;
                                                insert errobj into error.objects;
                                                insert error into args.errors;
                                              end if;
                                          on (NotFound)
                                            -- rid in adef.parameters not
                                            -- found, since obj.root.root
                                            -- bogus.  Ignore this cattr
                                            -- and continue.
                                          end block;
                                      end for;
                                  on (NotFound)
                                    -- Can't find ascope, so bad execution_environment in attribute def'n.
                                    -- Don't print error here.
                                  end block;
                              else
                                error := args.errorTemplate;
                                unite errObj.charstring from 
                                "wrong number of arguments for constraint attribute of constraint pretypestate";
                                insert errObj into error.objects;
                                unite errobj.attributeid from copy of attdef.attributeid;
                                insert errobj into error.objects;
                                insert error into args.errors;
                              end if;
                          on (NotFound)
                            error := args.errorTemplate;
                            unite errObj.charstring from 
                            "definition for constraint attribute in constraint pretypestate not found";
                            insert errObj into error.objects;
                            unite errobj.attributeid from copy of attdef.attributeid;
                            insert errobj into error.objects;
                            insert error into args.errors;
                          end block;
                      end if;
                  end for;
                -- check the created formal typestates
                for formentry in formtstable[] 
                  inspect
                    call args.checkFormal_typestate(formentry.ts,
                        formentry.basetype,
                        args.defs,
                        args.typenames,
                        evaluate errtem: error from
                            block declare
                                errobj2: errorobject;
                              begin
                                errtem := args.errortemplate;
                                unite errobj2.charstring from 
                                " in constraint pretypestate";
                                insert errobj2 into errtem.objects;
                                unite errobj2.attributeid from copy of attdef.attributeid;
                                insert errobj2 into errtem.objects;
                              end block;
                          end,
                        args.errors,
                        args.checkComp_list,
                        args.fixfull);
                  end for;
              end inspect;  -- mscope
          on (notfound)
            print charstring#"Whoa! unexpected notfound in last block of checkconstraints";
          on (others)
            print charstring#"Whoa! unexpected others in last block of checkconstraints";
            exit die;
          end block;   
      end for;  -- attdef
  end inspect;

return args;

on(checkcircular_typestate.discarded)
  print charstring#"Whoa! unexpected checkcircular_typestate.discarded exception in checkconstraints";
on(notfound)
  print charstring#"Whoa! unexpected notfound exception in checkconstraints";
on (others)
  print charstring#"Whoa! unexpected others exception in checkconstraints";
on exit (die)
  print charstring#"dying...";
end process
