-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)fmtattrname.p	1.5 1/8/91

FmtAttrName : USING(AbsFormat) 
PROCESS (FormatAttributeNameInit : FormatAttributeNameInport )
-- procedure to Format a typename
-- algorithm: 
-- if INIT, CASE, or FULL, Format the appropriate keyword
-- for a constraint: Format the module name, a "!", then the constraintname
  DECLARE
    FP: FormatAttributeNameCall ;
  BEGIN
    RECEIVE FP FROM FormatAttributeNameInit;
    SELECT (CASE OF FP.AttributeName)
      WHERE('initialized') 
        FP.FormatValue <- "INIT";
      WHERE('case')
        FP.FormatValue <- "CASE";
      WHERE ('checked')
	FP.FormatValue <- "CHECKED";
      WHERE ('checkeddefinitions')
	FP.FormatValue <- "CHECKEDDEFINITIONS";
      WHERE('full')
        FP.FormatValue <- "FULL";
      OTHERWISE
        REVEAL FP.AttributeName.Constraint;
	BLOCK
	  BEGIN
	    INSPECT DefinitionMap IN FP.DefinitionsMap WHERE(DefinitionMap.Id = FP.AttributeName.Constraint.ModuleId)
	      BEGIN
		FP.FormatValue := DefinitionMap.Name;
		INSERT '!' INTO FP.FormatValue;
		BLOCK
		  BEGIN
		    INSPECT AttributeInfo IN DefinitionMap.Attributes WHERE(AttributeInfo.Attribute = FP.AttributeName.Constraint.AttributeId)
		      BEGIN
			MERGE COPY OF AttributeInfo.Name INTO FP.FormatValue;
		      END INSPECT;
		    ON (NotFound)
		      MERGE "??" INTO FP.FormatValue;
		  END BLOCK;
	      END INSPECT;
	    ON (NotFound)
	      FP.FormatValue <- "??!??";
	  END BLOCK;
      END SELECT;
    RETURN FP;
  END PROCESS
