/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* File: Makefile */
/* Author: David F. Bacon */
/* SCCS info: @(#)Makefile	1.10 2/7/92  */

/* Format services modules */
PFILES	=	fmtattr.p fmtfmlattr.p fmtroot.p fmtattrname.p \
		fmtfmlts.p fmtcomps.p fmtobject.p fmttype.p fmtts.p \
		fmtstmt.p fmtopcode.p fmthandlername.p \
		getformatters.p printdef.p
PROCOBJS =	fmtattr.po fmtfmlattr.po fmtroot.po fmtattrname.po \
		fmtfmlts.po fmtcomps.po fmtobject.po fmttype.po fmtts.po \
		fmtstmt.po fmtopcode.po fmthandlername.po \
		getformatters.po printdef.po
PROCOBJSZ =	fmtattr.po.Z fmtfmlattr.po.Z fmtroot.po.Z fmtattrname.po.Z \
		fmtfmlts.po.Z fmtcomps.po.Z fmtobject.po.Z fmttype.po.Z fmtts.po.Z \
		fmtstmt.po.Z fmtopcode.po.Z fmthandlername.po.Z \
		getformatters.po.Z printdef.po.Z


#include "includefile"

INTERFACE =	$(HROOT)/interface

/* targets */

all:	$(PFILES) compileprocs
install: all
	cp getformatters.po printdef.po $(PROCDIR)

chcode:
	$(CHCODECMD) getformatters.po printdef.po
chcompile:
	$(CHCOMPILECMD) getformatters.po printdef.po


/* fmtopcode.p is generated from the operator table built in interface */
fmtopcode.p: fmtopcode.pp fmtopcode.body

fmtopcode.body: $(INTERFACE)/operator.table fmtopcode.awk
	awk -f fmtopcode.awk $(INTERFACE)/operator.table > fmtopcode.body

/* Other dependencies */
getformatters.po: fmtattr.po fmtfmlattr.po fmtroot.po fmtattrname.po \
		fmtfmlts.po fmtcomps.po fmtobject.po fmttype.po fmtts.po \
		fmtstmt.po fmtopcode.po fmthandlername.po

/* cleanup */

clean::
	rm -f fmtopcode.body fmtopcode.p
