-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)unqualname.d	1.2 3/13/90

-- This data structure is maintained while compiling a definitions module to
-- detect ambiguous type references of the following nature: if a name is
-- defined in an imported module and in the module being compiled, then a
-- forward reference to the name would look like it was uniquely defined in
-- the imported module.  thus, we must save all unqualified names which have
-- been resolved, and when a name is defined, we check that it has not been
-- resolved as an unqualified name.  the code for this is in unqualname.ch

unqualname: using (predefined) definitions

  unqualnames: table of unqual { full } keys (istype,name);

  unqual: record (
    name: charstring,		-- name of reference
    line: integer,		-- where it occurred
    istype: boolean		-- type or attribute name?
  );

end definitions
