/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)resdefs.h	1.3 3/13/90 */

#define zap_string(s) (*s=0)
				/* set string to "" */

#define isemptystring(s) (*s==0)
				/* is it "" ? */

typedef struct {
    object *moduleid;		/* resolved module or unknown */
    char *name;			/* name of type or attribute */

} qual_name;

typedef struct {
    char *name;			/* name of the rootid */
    object *typename;		/* its type */
    char *pragm;		/* optional pragma */

} decl;

typedef struct {
    object *table;		/* table being selected from */
    object *selector;		/* the selector record */
    char *name;			/* name of the element */

} selrec;


typedef enum {
    No_Error = 0,		/* no error at all */
    Information,		/* purely informational */
    Warning,			/* warning; all phases may proceed */
    Inhibit_Codegen,		/* can continue; don't codegen */
    Inhibit_Typestate,		/* can continue; stop after type checking */
    Inhibit_Type,		/* can continue; stop after resolution */
    Stop_Now,			/* can't continue; non-fatal */
    Fatal			/* can't continue; internal error */

} error_severity;

#define ERROR_LEVELS 8
				/* could say "((int) Fatal)+1", but that */
				/*   might be nonportable. */

#define LASTPHASE Inhibit_Type
				/* for resolution, this means don't go to */
				/*  the next phase. */
