/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* File: Makefile.ligen */
/* Author: Andy Lowry */
/* SCCS Info: @(#)Makefile	1.12 5/2/91 */

/* This makefile builds LI sources for the Hermes code generator. */

/* Files needed from source directory */
PPFILES =	codegen.pp cginit.pp cgprocess.pp cgprocinit.pp \
			cgclause.pp cgstmt.pp cgdirectstmt.pp \
			cgtypedstmt.pp cgstmtstub.pp cgblock.pp \
			cgif.pp cgwhile.pp cgevery.pp cgexists.pp \
			cgextract.pp cgforinsp.pp cginsptbl.pp \
			cgremove.pp cgforall.pp cgposition.pp cgposofelt.pp \
			cgtheelement.pp cgselect.pp cgexprblock.pp \
			cgnamedlit.pp cgconvert.pp cgcase.pp \
			cgforenum.pp cginsppoly.pp cgnew.pp \
			cgselector.pp breakselector.pp newtableinfo.pp \
			bbassemble.pp objaddr.pp objalias.pp optimize.pp \
			cgatoi.pp lkuptype.pp typedef.pp compoffsets.pp \
			varcaseid.pp clauseusesobj.pp makeopmap.pp cgator.pp
OTHERSRC =	codegen.h
SOURCES =	$(PPFILES) $(OTHERSRC)

/* Hermes sources after running through cpp */
PFILES =	codegen.p cginit.p cgprocess.p cgprocinit.p \
			cgclause.p cgstmt.p cgdirectstmt.p \
			cgtypedstmt.p cgstmtstub.p cgblock.p \
			cgif.p cgwhile.p cgevery.p cgexists.p \
			cgextract.p cgforinsp.p cginsptbl.p \
			cgremove.p cgforall.p cgposition.p cgposofelt.p \
			cgtheelement.p cgselect.p cgexprblock.p \
			cgnamedlit.p cgconvert.p cgcase.p \
			cgforenum.p cginsppoly.p cgnew.p \
			cgselector.p breakselector.p newtableinfo.p \
			bbassemble.p objaddr.p objalias.p optimize.p \
			cgatoi.p lkuptype.p typedef.p compoffsets.p \
			varcaseid.p clauseusesobj.p makeopmap.p cgator.p
/* Pre-built objects from common build phase */
DOFILES	=	  	cginternal.do cginit.do \
			bbassemble.do objaddr.do compoffsets.do \
			exprtree.do cgstmt.do
DOFILESZ	=	cginternal.do.Z cginit.do.Z \
			bbassemble.do.Z objaddr.do.Z compoffsets.do.Z \
			exprtree.do.Z cgstmt.do.Z
OTHERCOMM =	opmap.obj
OTHERCOMMZ =	opmap.obj.Z
COMMFILES =	$(DOFILES) $(DOFILESZ) $(OTHERCOMM) $(OTHERCOMMZ)

/* LI source files produced from build */
LIFILES =	codegen.li cginit.li cgprocess.li cgprocinit.li \
			cgclause.li cgstmt.li cgdirectstmt.li \
			cgtypedstmt.li cgstmtstub.li cgblock.li \
			cgif.li cgwhile.li cgevery.li cgexists.li \
			cgextract.li cgforinsp.li cginsptbl.li \
			cgremove.li cgforall.li cgposition.li cgposofelt.li \
			cgtheelement.li cgselect.li cgexprblock.li \
			cgnamedlit.li cgconvert.li cgcase.li \
			cgforenum.li cginsppoly.li cgnew.li \
			cgselector.li breakselector.li newtableinfo.li \
			bbassemble.li objaddr.li objalias.li optimize.li \
			cgatoi.li lkuptype.li typedef.li compoffsets.li \
			varcaseid.li clauseusesobj.li makeopmap.li cgator.li

/* Get standard stuff */
#include "includefile"

/* Set GENHROOT to the root of the hermes file tree with the correct */
/* compiled definitions modules, if they are different from the floor */
/* version (which is used to do the compilations) */
GENHROOT =	$(HROOT)

/* Definition modules are loaded from the binaries for the version */
/* being generated in preferance to the current floor version */
DEFPATH =	.:$(GENHROOT)/bin:$(DEFDIR)

/* Additional flags for cpp */
EXTRACPPFLAGS = -DLIGEN -undef

/* Invoke the disassembler, and suppress all checking in pcom */
PCOMENV =	PCOMnotcheck= PCOMnotscheck= PCOMligen= PCOMnoobject=

/* default target builds all the LI sources */
all:	$(SOURCES) $(COMMFILES) $(PFILES)
	@lilist=`$(MAKE) -n lilist HROOT=$(HROOT) GENHROOT=$(GENHROOT)` ; \
		if [ "$$lilist" ] ; then \
		  echo "$(PCOMCMD) " $$lilist ; $(PCOMCMD) $$lilist ; fi
lilist:	$(LIFILES)	

/* Following suffix rule makes the above work */
.p.li:	$<
	$*

/* 'make install' copies all the generated LI files to the LI source */
/* directory.  This is where they are accessed during a bootstrapping */
/* build.  We copy them there rather than leaving them here so that we */
/* can empty out this and all the other build directories before */
/* starting the bootstrapping process. */
install:	all
	cp $(LIFILES) $(HROOT)/codegen/li

/* explicit dependencies for all the modules */
codegen.li:	codegen.p
codegen.p:	codegen.pp codegen.h

cginit.li:	cginit.p  cgstmt.do
cginit.p:	cginit.pp codegen.h

cgprocess.li:	cgprocess.p 
cgprocess.p:	cgprocess.pp codegen.h

cgprocinit.li:	cgprocinit.p 
cgprocinit.p:	cgprocinit.pp codegen.h

cgclause.li:	cgclause.p 
cgclause.p:	cgclause.pp codegen.h

cgstmt.li:	cgstmt.p   cgstmt.do
cgstmt.p:	cgstmt.pp codegen.h

cgdirectstmt.li: cgdirectstmt.p  
cgdirectstmt.p:	cgdirectstmt.pp codegen.h

cgtypedstmt.li:	cgtypedstmt.p  
cgtypedstmt.p:	cgtypedstmt.pp codegen.h

cgstmtstub.li:	cgstmtstub.p 
cgstmtstub.p:	cgstmtstub.pp codegen.h

cgevery.li:	cgevery.p 
cgevery.p:	cgevery.pp codegen.h

cgexists.li:	cgexists.p 
cgexists.p:	cgexists.pp codegen.h

cgextract.li:	cgextract.p 
cgextract.p:	cgextract.pp codegen.h

cgforinsp.li:	cgforinsp.p 
cgforinsp.p:	cgforinsp.pp codegen.h

cginsptbl.li:	cginsptbl.p 
cginsptbl.p:	cginsptbl.pp codegen.h

cgposition.li:	cgposition.p 
cgposition.p:	cgposition.pp codegen.h

cgposofelt.li:	cgposofelt.p 
cgposofelt.p:	cgposofelt.pp codegen.h

cgremove.li:	cgremove.p 
cgremove.p:	cgremove.pp codegen.h

cgforall.li:	cgforall.p 
cgforall.p:	cgforall.pp codegen.h

cgtheelement.li: cgtheelement.p 
cgtheelement.p:	cgtheelement.pp codegen.h

cgselect.li:	cgselect.p 
cgselect.p:	cgselect.pp codegen.h

cgexprblock.li:	cgexprblock.p 
cgexprblock.p:	cgexprblock.pp codegen.h

cgnamedlit.li:	cgnamedlit.p 
cgnamedlit.p:	cgnamedlit.pp codegen.h

cgconvert.li:	cgconvert.p 
cgconvert.p:	cgconvert.pp codegen.h

cgforenum.li:	cgforenum.p 
cgforenum.p:	cgforenum.pp codegen.h

cginsppoly.li:	cginsppoly.p 
cginsppoly.p:	cginsppoly.pp codegen.h

cgblock.li:	cgblock.p 
cgblock.p:	cgblock.pp codegen.h

cgif.li:	cgif.p 
cgif.p:		cgif.pp codegen.h

cgwhile.li:	cgwhile.p 
cgwhile.p:	cgwhile.pp codegen.h

cgcase.li:	cgcase.p
cgcase.p:	cgcase.pp codegen.h

cgnew.li:	cgnew.p 
cgnew.p:	cgnew.pp codegen.h

cgselector.li:	cgselector.p 
cgselector.p:	cgselector.pp codegen.h

breakselector.li: breakselector.p  exprtree.do
breakselector.p: breakselector.pp codegen.h

newtableinfo.li: newtableinfo.p 
newtableinfo.p:	newtableinfo.pp codegen.h

bbassemble.li:	bbassemble.p  bbassemble.do
bbassemble.p:	bbassemble.pp codegen.h

objaddr.li:	objaddr.p  objaddr.do objalias.li
objaddr.p:	objaddr.pp codegen.h

objalias.li:	objalias.p  objaddr.do
objalias.p:	objalias.pp codegen.h

optimize.li:	optimize.p 
optimize.p:	optimize.pp codegen.h

cgatoi.li:	cgatoi.p 
cgatoi.p:	cgatoi.pp codegen.h

lkuptype.li:	lkuptype.p 
lkuptype.p:	lkuptype.pp codegen.h

typedef.li:	typedef.p  
typedef.p:	typedef.pp codegen.h

compoffsets.li:	compoffsets.p   compoffsets.do
compoffsets.p:	compoffsets.pp codegen.h

varcaseid.li:	varcaseid.p 
varcaseid.p:	varcaseid.pp codegen.h

clauseusesobj.li: clauseusesobj.p 
clauseusesobj.p: clauseusesobj.pp codegen.h

makeopmap.li:	makeopmap.p 
makeopmap.p:	makeopmap.pp codegen.h

cgator.li:	cgator.p 
cgator.p:	cgator.pp codegen.h

/* Create links to sources and common object files */
$(SOURCES):
	@ if [ ! -f $@ ] ; then ln -s $(HROOT)/codegen/$@ . ; fi
$(COMMFILES):
	@ if [ ! -f $@ ] ; then ln -s $(HROOT)/codegen/com/$@ . ; fi

clean::
	rm -f $(LIFILES) $(SOURCES) $(COMMFILES
	rm -f `echo "$(PPFILES) " | sed "s/\.pp /.p /g"` 2>/dev/null
