-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: atoi.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)cgatoi.pp	1.6 3/13/90

-- This process takes a string of digits and converts it into an
-- integer.  An initial sign is allowed.

#include "typemark.h"
#include "codegen.h"

cgatoi: using (cgInternal)

process (Q: atoiQ)
  
declare
  args: atoi;
  sign: integer;
  scopy: charstring;
  zcode: integer;
  ten: integer;
begin
  receive args from Q;

  args.i := ZERO;
  scopy := args.s;
  zcode <- I(convert of C('0'));
  ten <- I(10);

  -- handle first char... sign or digit
  block declare
    c: char;
  begin
    remove c from AREF(tmp,scopy,ZERO);
    select c
    where (C('+'))
      sign <- ONE;
    where (C('-'))
      sign <- NEG1;
    otherwise
      sign <- ONE;
      args.i <- I(I(convert of c) - zcode);
    end select;
  end block;
  
  for c in scopy[] inspect
    args.i <- I(args.i * ten);
    args.i <- I(args.i + I(I(convert of c) - zcode));
  end for;
  
  args.i <- I(args.i * sign);

  return args;
  
end process
