/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)keysets.ch	1.6 9/5/91 */

#include "cherm.h"

#include "interpform.cd"

objectp whole_key;		/* keys (*) */
objectp firstelem_key;		/* keys (f1) */
objectp secondelem_key;		/* keys (f2) */
objectp firstandthird_key;	/* keys (f1,f3) */
objectp firstandsecond_keyset;	/* keys (f1) (f2) */
objectp epmap_keyset;		/* keys (f1,f2) (f1,f3) */

hobject(whole_kobj, table);	/* keys (*) */
hobject(firstelem_kobj, table);	/* keys (f1) */
hobject(secondelem_kobj, table); /* keys (f2) */
hobject(firstandthird_kobj, table); /* keys (f1,f3) */
hobject(firstandsecond_kobj, table); /* keys (f1) (f2) */
hobject(epmap_kobj, table);	/* keys (f1,f2) (f1,f3) */

#define newvec(x) vec_new_table(x, keyqual)

#define Finalize(obj) (*(obj)->tsdr->finalize)((obj)->value, F_DISCARD, nil)

hobject(Keyqualv, record);

objectp keyqual = Keyqualv;


status
init_keys()
{
    status make_singlekey(), make_doublekey();
    void free_keys();

    hobject(key, table);
    hobject(formalroot, table);


    /* start everything out at bottom */
    set_bottom(whole_kobj);
    set_bottom(firstelem_kobj);
    set_bottom(secondelem_kobj);
    set_bottom(firstandthird_kobj);
    set_bottom(firstandsecond_kobj);
    set_bottom(epmap_kobj);
    set_bottom(key);
    set_bottom(formalroot);

    if (new_record(keyqual, integer_pair) isnt Normal) goto cleanup;
    if (ilit(keyqual@integer_pair__int_one, 2) isnt Normal) goto cleanup;
    if (ilit(keyqual@integer_pair__int_two, 2) isnt Normal) goto cleanup;
	
    if (!newvec(whole_kobj)) goto cleanup; /* keys (*) */
    if (!newvec(key)) goto cleanup;
    if (!newvec(formalroot)) goto cleanup;
    if (insert(key, formalroot) isnt Normal) goto cleanup;
    if (insert(whole_kobj, key) isnt Normal) goto cleanup;
	
    if (!newvec(firstelem_kobj)) goto cleanup; /* keys (0) */
    if (!make_singlekey(key, 0)) goto cleanup;
    if (insert(firstelem_kobj, key) isnt Normal) goto cleanup;
	
    if (!newvec(secondelem_kobj)) goto cleanup; /* keys (1) */
    if (!make_singlekey(key, 1)) goto cleanup;
    if (insert(secondelem_kobj, key) isnt Normal) goto cleanup;
    
    if (!newvec(firstandsecond_kobj)) goto cleanup; /* keys (0) (1) */
    if (!make_singlekey(key, 0)) goto cleanup;
    if (insert(firstandsecond_kobj, key) isnt Normal) goto cleanup;
    if (!make_singlekey(key, 1)) goto cleanup;
    if (insert(firstandsecond_kobj, key) isnt Normal) goto cleanup;
	
    if (!newvec(firstandthird_kobj)) goto cleanup; /* keys (0,2) */
    if (!make_doublekey(key, 0, 2)) goto cleanup;
    if (insert(firstandthird_kobj, key) isnt Normal) goto cleanup;
    
    if (!newvec(epmap_kobj)) goto cleanup; /* keys (0,1) (0,3) */
    if (!make_doublekey(key, 0, 1)) goto cleanup;
    if (insert(epmap_kobj, key) isnt Normal) goto cleanup;
    if (!make_doublekey(key, 0, 2)) goto cleanup;
    if (insert(epmap_kobj, key) isnt Normal) goto cleanup;
	
    /* everything succeeded... set global pointers and succeed */
    whole_key = whole_kobj;
    firstelem_key = firstelem_kobj;
    secondelem_key = secondelem_kobj;
    firstandthird_key = firstandthird_kobj;
    firstandsecond_keyset = firstandsecond_kobj;
    epmap_keyset = epmap_kobj;
    return(SUCCESS);

  cleanup:    
    nilerror("init_keys","Unable to allocate global keysets");
    free_keys();
    Finalize(key);
    Finalize(formalroot);
    return(FAILURE);
}


/* Free all the key objects that were built by init_keys above */
void
free_keys()
{
    Finalize(whole_kobj);
    Finalize(firstelem_kobj);
    Finalize(secondelem_kobj);
    Finalize(firstandthird_kobj);
    Finalize(firstandsecond_kobj);
    Finalize(epmap_kobj);
    Finalize(keyqual);
}


static status
make_singlekey(thekey, comp)
objectp thekey;
int comp;
{
    status make_comp();

    hobject(component, table);

    set_bottom(component);

    if (!newvec(thekey)) goto cleanup;
    if (!make_comp(component, comp)) goto cleanup;
    if (insert(thekey, component) isnt Normal) goto cleanup;
    return(SUCCESS);

  cleanup:
    Finalize(component);
    Finalize(thekey);
    return(FAILURE);
}

static status
make_doublekey(thekey, comp1, comp2)
objectp thekey;
int comp1, comp2;
{
    status make_comp();

    hobject(component, table);

    set_bottom(component);

    if (!newvec(thekey)) goto cleanup;
    if (!make_comp(component, comp1)) goto cleanup;
    if (insert(thekey, component) isnt Normal) goto cleanup;
    if (!make_comp(component, comp2)) goto cleanup;
    if (insert(thekey, component) isnt Normal) goto cleanup;
    return(SUCCESS);

  cleanup:
    Finalize(component);
    Finalize(thekey);
    return(FAILURE);

}


static status
make_comp(comp, num)
objectp comp;
int num;
{
    hobject(ival, integer);

    set_bottom(ival);

    if (!newvec(comp)) goto cleanup;
    if (ilit(ival, num) isnt Normal) goto cleanup;
    if (insert(comp, ival) isnt Normal) goto cleanup;
    return(SUCCESS);

  cleanup:
    Finalize(ival);
    Finalize(comp);
    return(FAILURE);
}
