/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* SCCS Info: @(#)Makefile	1.10 2/7/92 */

#include "includefile"

SOURCES	=	cherm.c keysets.c newtable.c hermcall.c
OBJECTS	=	cherm.o keysets.o newtable.o hermcall.o

all:	libcherm.a

libcherm.a: $(OBJECTS)
	ar r libcherm.a $?
	$(RANLIB) libcherm.a

llib-lcherm.ln: $(OBJECTS)
	$(LINT) $(LFLAGS) $(SOURCES)
	$(LINT) -Ccherm $(LFLAGS) $(SOURCES) >/dev/null

cherm.o: declare_o.h datarep.h hcalls.h

declare_o.h: $(HROOT)/li/o_*.c
	egrep "^o_|NILOP" $(HROOT)/li/?*.c | \
		sed -e 's/.*:\([a-z_]*\)[ 	]*(args)/void \1();/' \
		    -e 's=.*:NILOP(\([a-z_]*\))[ 	]*=void \1();=' \
			>declare_o.h

datarep.h: $(HROOT)/li/recursiv.c
	sed -f datarep.sed $(HROOT)/li/recursiv.c >datarep.h

hcalls.h: $(HROOT)/interface/greencard
	awk -f hcalls.awk $(HROOT)/interface/greencard >hcalls.h

keysets.c: keysets.ch 
	$(CHERM) keysets.ch | $(CHERM2) >keysets.c

newtable.c: newtable.ch
	$(CHERM) newtable.ch | $(CHERM2) >newtable.c

/*.ch.c: */
/*	sed -f cherm2c.sed $< >$@ */

clean::
	rm -f hcalls.h manualmacros datarep.h \
	  declare_o.h keysets.c newtable.c
